/* *INDENT-OFF* */

/****************************************************************************
 *                                                                          *
 * module : testpipe.c                                                      *
 *                                                                          *
 * purpose: yawn...                                                         *
 *                                                                          *
 ****************************************************************************/

/****************************************************************************
 includes
 */

//dunno what I really need yet - do I need to include lots of stuff or
//can I reasonably rely on nodePS2All.h including everything for me?

#include "nodePS2All.h"

#include "ps2allatomic.h"
#include "ps2allsector.h"
#include "ps2allim3d.h"

#include "testpipe.h"


/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   Functions

   !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */


#if (0)

########################
####  DONE TO HERE  ####
#### [I.E. CURRENT] ####
########################

 DONE: need to put into makedir/pipe/p2 and get making...
 DONE: before running will need to make sure all members of ps2AllPipeData are present
      and everythings exposed by RWPUBLIC/RWPUBLICEND in ps2All.h that need be...
 DONE: need to create pipes in here... means need construction API... only first-pass
      copy-PS2Manager one so shouldnt be too hard - but do need to add various CBs
      and use an API func with enums to set them up for initial atomic/sector pipes...
 DONE: atomic/sectors
 DONE: fastIm3D render pipe
 DONE: will need to recast instance CBs to use ps2AllPipeData not DMASessionRecord and
      PS2Mesh (dungeon doesnt use any CBs I think...) use ppskin demo to test skinning
 DONE: couple of asserts to check on once compiling... also check mentally
      check todo[1]:s and todo[2]:s
 DONE: STAGE 1A: make it like PS2Manager as in material pipes are irrelevant
 DONE: STAGE 1B: create a fake material node and a material pipe API
   STAGE 1C: after "the meeting" to discuss unresolved PS2All issues, proceed on what
            was decided

#endif /* (0) */



/* START TEMPORARY DEBUGGING FUNCS */

#include "matputil.h"
#include "nodePS2MatInstance.h"

extern void  PrintResEntry(RwResEntry *resEntry, const RwChar *string);
extern void  PrintPS2ManagerResEntryHeader(RwResEntry *resEntry, const RwChar *string);
extern void  PrintPS2AllResEntryHeader(RwResEntry *resEntry, const RwChar *string);
extern void *PS2ManagerResEntryGetData(RwResEntry *resEntry);
extern void *PS2AllResEntryGetData(RwResEntry *resEntry);
extern void  FixupPS2ResHeader(RwResEntry *original, RwResEntry *copy);
extern void  PrintPS2ResHeaderSizes(void);


void
PrintResEntry(RwResEntry *resEntry, const RwChar *string)
{
//    RWASSERT(NULL != resEntry);
    printf("%s RwResEntry: %x\n", string, (RwUInt32)((RwUInt8 *)resEntry));
    printf("%s RwResEntry->size: %d\n", string, resEntry->size);
    printf("%s RwResEntry->owner: %x\n", string, (RwUInt32)((RwUInt8 *)resEntry->owner));
    printf("%s RwResEntry->ownerRef: %x\n", string, (RwUInt32)((RwUInt8 *)resEntry->ownerRef));
    printf("%s RwResEntry->destroyNotify: %x\n", string, (RwUInt32)((RwUInt8 *)resEntry->destroyNotify));
}


void
PrintPS2ManagerResEntryHeader(RwResEntry *resEntry, const RwChar *string)
{
    rwPS2ResEntryHeader *ps2ResHeader;
//    RWASSERT(NULL != resEntry);
    ps2ResHeader = RWPS2RESHEADERFROMRESENTRY(resEntry);
    printf("%s ps2ResHeader: %x\n", string, (RwUInt32)((RwUInt8 *)ps2ResHeader));
    printf("%s ps2ResHeader->data: %x\n", string, (RwUInt32)((RwUInt8 *)ps2ResHeader->data));
    printf("%s ps2ResHeader->numVerts: %d\n", string, ps2ResHeader->numVerts);
    printf("%s ps2ResHeader->batchSize: %d\n", string, ps2ResHeader->batchSize);
    printf("%s ps2ResHeader->numBatches: %d\n", string, ps2ResHeader->numBatches);
    printf("%s ps2ResHeader->batchesPerTag: %d\n", string, ps2ResHeader->batchesPerTag);
    printf("%s ps2ResHeader->morphStart: %d\n", string, ps2ResHeader->morphStart);
    printf("%s ps2ResHeader->morphFinish: %d\n", string, ps2ResHeader->morphFinish);
    printf("%s ps2ResHeader->morphNum: %d\n", string, ps2ResHeader->morphNum);
    printf("%s PS2RESHEADER CLQUICKINFO AND FIELDRECS TO BE PRINTED...\n", string);
}


void
PrintPS2AllResEntryHeader(RwResEntry *resEntry, const RwChar *string)
{
    rwPS2AllResEntryHeader *ps2ResHeader;
//    RWASSERT(NULL != resEntry);
    ps2ResHeader = RWPS2ALLRESENTRYHEADERFROMRESENTRY(resEntry);
    printf("%s ps2ResHeader: %x\n", string, (RwUInt32)((RwUInt8 *)ps2ResHeader));
    printf("%s ps2ResHeader->data: %x\n", string, (RwUInt32)((RwUInt8 *)ps2ResHeader->data));
    printf("%s ps2ResHeader->numVerts: %d\n", string, ps2ResHeader->numVerts);
    printf("%s ps2ResHeader->batchSize: %d\n", string, ps2ResHeader->batchSize);
    printf("%s ps2ResHeader->numBatches: %d\n", string, ps2ResHeader->numBatches);
    printf("%s ps2ResHeader->batchesPerTag: %d\n", string, ps2ResHeader->batchesPerTag);
    printf("%s ps2ResHeader->morphStart: %d\n", string, ps2ResHeader->morphStart);
    printf("%s ps2ResHeader->morphFinish: %d\n", string, ps2ResHeader->morphFinish);
    printf("%s ps2ResHeader->morphNum: %d\n", string, ps2ResHeader->morphNum);
    printf("%s PS2RESHEADER CLQUICKINFO AND FIELDRECS TO BE PRINTED...\n", string);
}


void *
PS2ManagerResEntryGetData(RwResEntry *resEntry)
{
    rwPS2ResEntryHeader *ps2ResHeader =
        RWPS2RESHEADERFROMRESENTRY(resEntry);
    return(ps2ResHeader->data);
}


void *
PS2AllResEntryGetData(RwResEntry *resEntry)
{
    rwPS2AllResEntryHeader *ps2ResHeader =
        RWPS2ALLRESENTRYHEADERFROMRESENTRY(resEntry);
    return(ps2ResHeader->data);
}


void
FixupPS2ResHeader(RwResEntry *original, RwResEntry *copy)
{
    rwPS2ResEntryHeader *oldPS2ResHeader =
        RWPS2RESHEADERFROMRESENTRY(original);
    rwPS2ResEntryHeader *newPS2ResHeader =
        RWPS2RESHEADERFROMRESENTRY(copy);
    RwInt32 difference;

    RWFUNCTION(RWSTRING("FixupPS2ResHeader"));

    difference = ((RwUInt32)(RwUInt8 *)copy) - ((RwUInt32)(RwUInt8 *)original);
    RWASSERT(oldPS2ResHeader->data == newPS2ResHeader->data);
    newPS2ResHeader->data = (u_long128 *)(((RwUInt8 *)oldPS2ResHeader->data) + difference);

    RWRETURNVOID();
}

void
PrintPS2ResHeaderSizes(void)
{
    printf("sizeof(rwPS2ResEntryHeader) = %d, sizeof(rwPS2AllResEntryHeader) = %d\noffsetof(rwPS2ResEntryHeader, data) = %d, offsetof(rwPS2AllResEntryHeader, data) = %d\n",
           sizeof(rwPS2ResEntryHeader), sizeof(rwPS2AllResEntryHeader),
           offsetof(rwPS2ResEntryHeader, data), offsetof(rwPS2AllResEntryHeader, data));
}

/* END TEMPORARY DEBUGGING FUNCS */

