/*
 * Data structures for core functionailty of custom pipelines
 * Copyright (c) Criterion Software Limited
 */

/****************************************************************************
 *                                                                          *
 * module : p2stdclsw.h                                                     *
 *                                                                          *
 * purpose: declare standard world pipeline clusters and associated types   *
 *                                                                          *
 ****************************************************************************/

#ifndef P2STDCLSW_H
#define P2STDCLSW_H

/****************************************************************************
 includes
 */

#include "rwcore.h"
#include "balight.h"

/****************************************************************************
 global defines
 */

#define _DEFAULTSTRIDE     ((RwUInt32)0)
#define _DEFAULTATTRIBUTES ((RwUInt32)0)
#define _ATTRIBUTESET      ((const char *)NULL)


/****************************************************************************
 global types
 */

/* see Lights.csl below */
/* RWPUBLIC */
typedef RpLight *RxLight;
/* RWPUBLICEND */


/****************************************************************************
 global prototypes
 */

/* RWPUBLIC */
#ifdef    __cplusplus
extern "C"
{
#endif                          /* __cplusplus */

extern RxClusterDefinition RxClLights; /* Uses the RxLight type (see above) */

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */


/* RWPUBLICEND */

#endif /* P2STDCLSW_H */
