
/***************************************************************************
 *                                                                         *
 * Module  : bapiputl.c                                                    *
 *                                                                         *
 * Purpose : Default pipe utility code                                     *
 *                                                                         *
 **************************************************************************/

/****************************************************************************
 Includes
 */

#include <rwcore.h>

#include "bapipif.h"
#include "atompipe.h"
#include "sectpipe.h"
#include "litepipe.h"
#include "baworld.h"

static const char rcsid[] __RWUNUSED__ = "@@(#)$Id: bapipif.c,v 1.4 2000/07/11 15:25:33 johns Exp $";


/****************************************************************************
 Global prototypes
 */

/****************************************************************************
 Local Types
 */

/****************************************************************************
 Local (Static) Prototypes
 */

static RwBool attachWorldPipe(void);

/****************************************************************************
 Local Defines
 */

/****************************************************************************
 Globals (across program)
 */

/****************************************************************************
 Local (static) Globals
 */

static const rpWorldPipeInterface worldPipeIf =
{
    attachWorldPipe,
    initGenericAtomPipe,
    initGenericSectPipe,
    initGenericLightApply
};

/****************************************************************************
 attachWorldPipe

 On entry   : None
 On exit    : TRUE on success
 */

static RwBool 
attachWorldPipe(void)
{
    RWFUNCTION(RWSTRING("attachWorldPipe"));

    RWRETURN(TRUE);
}

/****************************************************************************
 rpGetWorldPipeInterface

 On entry   : None
 On exit    : Pipeline interface block
 */

const rpWorldPipeInterface *
rpGetWorldPipeInterface(void)
{
    RWFUNCTION(RWSTRING("rpGetWorldPipeInterface"));

    RWRETURN(&worldPipeIf);
}
