/***************************************************************************
 *                                                                         *
 * Module  : nhsstats.h                                                      *
 *                                                                         *
 * Purpose : World handling functions.                                     *
 *                                                                         *
 **************************************************************************/

#ifndef RTNHSSTATS_H
#define RTNHSSTATS_H

/****************************************************************************
 Includes
 */

#include "rwcore.h"

#include "nhsworld.h"
#include "rtimport.h"

/****************************************************************************
 Defines
 */

/****************************************************************************
 Global types
 */

typedef struct RtBuildSectorClipStatistics RtBuildSectorClipStatistics;
struct RtBuildSectorClipStatistics
{
    RwInt32 numMaterialLeft;
    RwInt32 numMaterialRight;
    RwInt32 nLeft;
    RwInt32 nRight;
    RwInt32 nSplit;

    RwReal overlapLeft;
    RwReal overlapRight;

    RwBool alphaInOverlap;
};

/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern "C"
{
#endif                          /* __cplusplus */

extern void
_rtImportBuildSectorGetClipStatistics(RtWorldImportBuildSector *buildSector,
                                RtBuildSectorClipStatistics *stats,
                                RwInt32 plane,
                                RwReal value);

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

#endif /* RTNHSSTATS_H */
