
/***************************************************************************
 *                                                                         *
 * Module  : nhsutl.h                                                      *
 *                                                                         *
 * Purpose : World handling functions.                                     *
 *                                                                         *
 **************************************************************************/

#ifndef RTNHSTSMPLX_H
#define RTNHSTSMPLX_H

/****************************************************************************
 Includes
 */

#include "rwcore.h"

#include "nhsworld.h"
#include "rtimport.h"
#include "nhswing.h"

/****************************************************************************
 Defines
 */

/****************************************************************************
 Global types
 */
typedef struct RtSimplexVertex RtSimplexVertex;
typedef struct RtSimplexVertex *RtSimplexVertexPtr;
struct RtSimplexVertex
{
    RtSimplexVertexPtr  next;
    RtWorldImportVertex *vpVert;
    RwDV3d              edge;
    RtDM4d              bary;
    RwDReal             signedArea;
};

typedef struct RtSimplexState RtSimplexState;
struct RtSimplexState
{
    RwDV3d              normal;
    RwDReal             normal_w;
    RwInt32             vertexCount;
    RwInt32             numPolygons;
    RwInt32             numBoundaries;
    RtWorldImportBuildVertex *boundaries;
    RtWorldImport      *wpNoHS;
    RtWingPoly         *WingPoly;
    RtSimplexVertexPtr  simplexBuffer;
    RtSimplexVertexPtr  head;
};

/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern              "C"
{
#endif                          /* __cplusplus */

extern void
_rtImportWingPolyTriangulate(RtSimplexState * simplexState, RtWingPoly * WingPoly);

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

#endif                          /* RTNHSTSMPLX_H */
