
/***************************************************************************
 *                                                                         *
 * Module  : nhsutl.h                                                      *
 *                                                                         *
 * Purpose : World handling functions.                                     *
 *                                                                         *
 **************************************************************************/

#ifndef RTNHSCOND_H
#define RTNHSCOND_H

/****************************************************************************
 Includes
 */

#include "rwcore.h"
#include "nhsworld.h"
#include "rtimport.h"

/****************************************************************************
 Defines
 */

#define _ROOT3                  ((RwReal)1.73205080757)
#define _COS_THIRTY             ((_ROOT3)/((RwReal)2))
#define WELDTHRESHOLDANGULAR    ((RwReal)_COS_THIRTY)
#define WELDTHRESHOLDPOSITIONAL (((RwReal)1)/((RwReal)(1<<8)))

/****************************************************************************
 Global types
 */

typedef struct _rwSortVertex _rwSortVertex;
struct _rwSortVertex
{
    RtWorldImportVertex *vpVert;
    RwReal              dist;
};

/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern              "C"
{
#endif                          /* __cplusplus */

extern RwReal
_rtImportGetWeldThresholdPositional(void);

extern void
_rtImportSetWeldThresholdPositional(RwReal componentThreshold);

extern RwReal
_rtImportGetWeldThresholdAngular(void);

extern void
_rtImportSetWeldThresholdAngular(RwReal cosineThreshold);

extern void
_rtImportBuildSectorConditionGeometry(RtWorldImport * wpNoHS,
                                RtWorldImportBuildSector * buildSector,
                                RtWorldImportParameters *
                                conversionParams,
                                RpMaterialList * matList);

#if (0)
/* e.g. see app/Demo/re/src/main.c */
extern void BSWrite(RtWorldImportBuildSector * bs,
                    RpMaterialList * ml,
                    char *filename);

#define BuildSectorWrite(_limit, _name)          \
MACRO_START                                      \
{                                                \
    if (buildSector->numPolygons > (_limit) )    \
    {                                            \
        BSWrite(buildSector, matList, (_name));  \
    }                                            \
}                                                \
MACRO_STOP

#endif /* (0) */

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

#define _rtImportBuildSectorGetWeldThresholdPositional() \
        _rtImportGetWeldThresholdPositional()

#define _rtImportBuildSectorGetWeldThresholdAngular() \
        _rtImportGetWeldThresholdAngular()

#define _rtImportBuildSectorSetWeldThresholdPositional(_componentThreshold) \
        _rtImportSetWeldThresholdPositional(_componentThreshold)

#define _rtImportBuildSectorSetWeldThresholdAngular(_cosineThreshold) \
        _rtImportSetWeldThresholdAngular(_cosineThreshold)

#endif                          /* RTNHSCOND_H */
