/***************************************************************************
 *                                                                         *
 * Module  : babintex.h                                                    *
 *                                                                         *
 * Purpose : Binary texture handling functions.                            *
 *                                                                         *
 **************************************************************************/

#ifndef RWBINTEX_H
#define RWBINTEX_H

/****************************************************************************
 Includes
 */

#include "batextur.h"
#include "bastream.h"

/****************************************************************************
 Defines
 */

/* RWPUBLIC */
/****************************************************************************
 Global types
 */

typedef struct rpTextureChunkInfo RwTextureChunkInfo;
struct rpTextureChunkInfo
{
    RwTextureFilterMode filtering;
    RwTextureAddressMode addressing;
};

/* Bit flags defining properties of textures when stream */
enum RwTextureStreamFlags
{
    rwNATEXTURESTREAMFLAG = 0x00,
    rwTEXTURESTREAMFLAGSUSERMIPMAPS = 0x01,
    rwTEXTURESTREAMFLAGSFORCEENUMSIZEINT = RWFORCEENUMSIZEINT
};
typedef enum RwTextureStreamFlags RwTextureStreamFlags;
/* RWPUBLICEND */

/****************************************************************************
 Global Variables 
 */

/* RWPUBLIC */
/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern "C"
{
#endif                          /* __cplusplus */

/* RWPUBLICEND */

/* The string serialisation functions */
extern RwBool _rwStringDestroy(RwChar *string);
extern RwUInt32 _rwStringStreamGetSize(const RwChar *string);
extern const RwChar *_rwStringStreamWrite(const RwChar *string, RwStream *stream);
extern RwChar *_rwStringStreamFindAndRead(RwChar *string, RwStream *stream);

/* Comparibility macros */

#define rwStringDestroy(string) \
       _rwStringDestroy(string)
#define rwStringStreamGetSize(string) \
       _rwStringStreamGetSize(string)
#define rwStringStreamWrite(string, stream) \
       _rwStringStreamWrite(string, stream)
#define rwStringStreamFindAndRead(string, stream) \
       _rwStringStreamFindAndRead(string, stream)


/* RWPUBLIC */
/* Texture binary format */
extern RwInt32 RwTextureRegisterPluginStream(RwUInt32 pluginID,
                                             RwPluginDataChunkReadCallBack readCB,
                                             RwPluginDataChunkWriteCallBack writeCB,
                                             RwPluginDataChunkGetSizeCallBack getSizeCB);
extern RwInt32 RwTextureSetStreamAlwaysCallBack(
                   RwUInt32 pluginID,
                   RwPluginDataChunkAlwaysCallBack alwaysCB);
extern RwUInt32 RwTextureStreamGetSize(const RwTexture *texture);
extern RwTexture *RwTextureStreamRead(RwStream *stream);
extern const RwTexture *RwTextureStreamWrite(const RwTexture *texture, RwStream *stream);
extern RwTextureChunkInfo *
RwTextureChunkInfoRead(RwStream *stream, RwTextureChunkInfo *textureChunkInfo, RwInt32 *bytesRead);

/* Texture dictionary binary format */
extern RwInt32 RwTexDictionaryRegisterPluginStream(RwUInt32 pluginID,
                                                   RwPluginDataChunkReadCallBack readCB,
                                                   RwPluginDataChunkWriteCallBack writeCB,
                                                   RwPluginDataChunkGetSizeCallBack getSizeCB);
extern RwInt32 RwTexDictionarySetStreamAlwaysCallBack(
                   RwUInt32 pluginID,
                   RwPluginDataChunkAlwaysCallBack alwaysCB);
extern RwUInt32 RwTexDictionaryStreamGetSize(const RwTexDictionary *texDict);
extern RwTexDictionary *RwTexDictionaryStreamRead(RwStream *stream);
extern const RwTexDictionary *RwTexDictionaryStreamWrite(const RwTexDictionary *texDict, RwStream *stream);

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

/* RWPUBLICEND */

#endif /* RWBINTEX_H */
