
#ifndef VERT_DEFS_H
#define VERT_DEFS_H


/* For use in the vertex shader descriptor */
#define VSD_REG_POS                     0
#define VSD_REG_WEIGHTS                 1
#define VSD_REG_INDICES                 2
#define VSD_REG_NORMAL                  3
#define VSD_REG_COLOR                   4
#define VSD_REG_TEXCOORDS               5


/* Input register - For use in the vertex shader code */
#define VSIN_REG_POS                    v0
#define VSIN_REG_WEIGHTS                v1
#define VSIN_REG_INDICES                v2
#define VSIN_REG_NORMAL                 v3
#define VSIN_REG_COLOR                  v4
#define VSIN_REG_TEXCOORDS              v5


/* Temporary register - For use in the vertex shader code */
#define VSTMP_REG_POS_TMP               r0
#define VSTMP_REG_POS_ACCUM             r1
#define VSTMP_REG_NORMAL_TMP            r2
#define VSTMP_REG_NORMAL_ACCUM          r3


/* Vertex shader defines */
#define VSCONST_REG_BASE                -36  /* (-36) in the constant register */

#define VSCONST_REG_TRANSFORM_OFFSET    VSCONST_REG_BASE
#define VSCONST_REG_TRANSFORM_SIZE      4

#define VSCONST_REG_WORLD_TRANSFORM_OFFSET    VSCONST_REG_TRANSFORM_OFFSET + VSCONST_REG_TRANSFORM_SIZE
#define VSCONST_REG_WORLD_TRANSFORM_SIZE      3

#define VSCONST_REG_DIR_LIGHT_OFFSET    VSCONST_REG_WORLD_TRANSFORM_OFFSET + VSCONST_REG_WORLD_TRANSFORM_SIZE
#define VSCONST_REG_DIR_LIGHT_SIZE      2

#define VSCONST_REG_MATRIX_OFFSET       -26//VSCONST_REG_DIR_LIGHT_OFFSET + VSCONST_REG_DIR_LIGHT_SIZE

/* Constant register - For use in the vertex shader code */
#define VSCONST_REG_TRANSFORM_X         c[0 + VSCONST_REG_BASE]
#define VSCONST_REG_TRANSFORM_Y         c[1 + VSCONST_REG_BASE]
#define VSCONST_REG_TRANSFORM_Z         c[2 + VSCONST_REG_BASE]
#define VSCONST_REG_TRANSFORM_W         c[3 + VSCONST_REG_BASE]
#define VSCONST_REG_WORLD_TRANSFORM_X   c[4 + VSCONST_REG_BASE]
#define VSCONST_REG_WORLD_TRANSFORM_Y   c[5 + VSCONST_REG_BASE]
#define VSCONST_REG_WORLD_TRANSFORM_Z   c[6 + VSCONST_REG_BASE]
#define VSCONST_REG_LIGHT_DIR           c[7 + VSCONST_REG_BASE]
#define VSCONST_REG_LIGHT_COLOR         c[8 + VSCONST_REG_BASE]
/* -c30 -> c95 Used for matrix palette */

#endif /* VERT_DEFS_H */