#ifndef SKIN_DEFS_H
#define SKIN_DEFS_H

/* For use in the vertex shader descriptor */
#define VSD_REG_POS                     0
#define VSD_REG_WEIGHTS                 1
#define VSD_REG_INDICES                 2
#define VSD_REG_NORMAL                  3
#define VSD_REG_COLOR                   4
#define VSD_REG_TEXCOORDS               5
#define VSD_REG_TEXCOORDS2              6

/* Input register - For use in the vertex shader code */
#define VSIN_REG_POS                    v0
#define VSIN_REG_WEIGHTS                v1
#define VSIN_REG_INDICES                v2
#define VSIN_REG_NORMAL                 v3
#define VSIN_REG_COLOR                  v4
#define VSIN_REG_TEXCOORDS              v5
#define VSIN_REG_TEXCOORDS2             v6

/* Temporary register - For use in the vertex shader code */

/* (keep r1 free for pairing up ILU instructions!) */
#define VSTMP_REG_ILU_TMP               r1
#define VSTMP_REG_POS_TMP               r2
#define VSTMP_REG_POS_ACCUM             r3
#define VSTMP_REG_NORMAL_TMP            r4
#define VSTMP_REG_NORMAL_ACCUM          r5
#define VSTMP_REG_CLAMP_TMP             r6
#define VSTMP_REG_DIST_TMP              r7
#define VSTMP_REG_ATTEN_TMP             r8
#define VSTMP_REG_BUMPDIR_TMP           r9
#define VSTMP_REG_COLOR_TMP             r11

/* Vertex shader defines */

/* per material constants as one contiguous block */
#define PER_MATERIAL_OFFSET             -96

/* always need a material color */
#define VSCONST_REG_MAT_COLOR_SIZE      1
#define VSCONST_REG_MAT_COLOR_OFFSET    -96

/* sometimes need some env map coefficients */
#define VSCONST_REG_ENV_SIZE            2
#define VSCONST_REG_ENV_OFFSET          -95

/* world transform used for bump mapping */
#define VSCONST_REG_BUMPWORLD_SIZE      3
#define VSCONST_REG_BUMPWORLD_OFFSET    -93

/* bump position in xyz and fudge factor in w */
#define VSCONST_REG_BUMPPOSFUDGE_SIZE   1
#define VSCONST_REG_BUMPPOSFUDGE_OFFSET -90

/* bump shifting fudge factor */
#define VSCONST_REG_BUMPSHIFT_SIZE      1
#define VSCONST_REG_BUMPSHIFT_OFFSET    -89

/* per atomic constants as one contiguous block */
#define PER_ATOMIC_OFFSET               -88

/* Always need a screenspace offset */
#define VSCONST_REG_SCREENSPACE_OFFSET  -88
#define VSCONST_REG_SCREENSPACE_SIZE    1

/* Always need a transform */
#define VSCONST_REG_TRANSFORM_OFFSET    -87
#define VSCONST_REG_TRANSFORM_SIZE      4

/* always need an ambient light */
#define VSCONST_REG_AMBIENT_SIZE        1
#define VSCONST_REG_AMBIENT_OFFSET      -83
 
/* optionally need some directional & point lights */
#define VSCONST_REG_DIR_LIGHT_SIZE      2
#define VSCONST_REG_DIR_LIGHT_OFFSET    -82

#define VSCONST_REG_PNT_LIGHT_SIZE      2

/* bones follow on from the per atomic constants
   Perl & C figure out where they go depending on # lights used... */

/* Constant register - For use in the vertex shader code */
#define VSCONST_REG_TRANSFORM_X         c[0 + VSCONST_REG_TRANSFORM_OFFSET]
#define VSCONST_REG_TRANSFORM_Y         c[1 + VSCONST_REG_TRANSFORM_OFFSET]
#define VSCONST_REG_TRANSFORM_Z         c[2 + VSCONST_REG_TRANSFORM_OFFSET]
#define VSCONST_REG_TRANSFORM_W         c[3 + VSCONST_REG_TRANSFORM_OFFSET]

#define VSCONST_REG_MAT_COLOR           c[VSCONST_REG_MAT_COLOR_OFFSET]

#define VSCONST_REG_AMBIENT             c[VSCONST_REG_AMBIENT_OFFSET]

#define VSCONST_REG_LIGHT_DIR           c[VSCONST_REG_DIR_LIGHT_OFFSET]


#endif /* SKIN_DEFS_H */
