/****************************************************************************
 *                                                                          *
 *  Module  :   x86matbl.h                                                  *
 *                                                                          *
 *  Purpose :   Intel x86 matrix-blending functions                         *
 *                                                                          *
 ****************************************************************************/

#ifndef X86MATBL_H
#define X86MATBL_H

/****************************************************************************
 Includes
 */

/****************************************************************************
 Defines
 */

/****************************************************************************
 Global Types
 */


/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern "C"
{
#endif                          /* __cplusplus */

#if defined( RWDEBUG )

extern void _rpSkinIntelx86ConfirmConstants(void);

#endif /* defined( RWDEBUG ) */


extern void _rpSkinIntelx86MatrixBlend( RwInt32 numVertices,
                                        RwMatrixWeights *matrixWeightsMap,
                                        RwUInt32 *matrixIndexMap,
                                        RwMatrix *matrixArray,
                                        RwV3d *vertices,
                                        const RwV3d *originalVertices,
                                        RwV3d *normals,
                                        const RwV3d *originalNormals,
                                        RwUInt32 stride);

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

#endif /* X86MATBL_H */
