#ifndef _SKY2_SKINGENERICNODE_H
#define _SKY2_SKINGENERICNODE_H

/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/
#include "rwcore.h"
#include "rpworld.h"

#include "rpskin.h"

#include "skinsky.h"

/*===========================================================================*
 *--- Private Types ---------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Global Variables ----------------------------------------------*
 *===========================================================================*/
extern SkinSkyVUCode SKY2_SkinGenericPRS __attribute__ ((section(".vudata")));
extern SkinSkyVUCode SKY2_SkinGenericPRL __attribute__ ((section(".vudata")));
extern SkinSkyVUCode SKY2_SkinSegmentsPRS __attribute__ ((section(".vudata")));
extern SkinSkyVUCode SKY2_SkinSegmentsPRL __attribute__ ((section(".vudata")));
extern SkinSkyVUCode SKY2_SkinBFacePRS __attribute__ ((section(".vudata")));

extern SkinSkyTransforms _rpSkinSkySkinGenericTransforms;

/*===========================================================================*
 *--- Private Defines -------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Functions -----------------------------------------------------*
 *===========================================================================*/
#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

/* PS2Manager Instance call back. */
extern RwBool
_rxPipelineNodePS2SkinGenericPS2ManagerInstanceCallBack(
    void **clusterData,
    RwUInt32 numClusters );

/* PS2 Transform setup. */
extern void
_rpSkinSkySkinGenericSetupTransforms(void);

/* PS2All call backs. */
extern RwBool
_rxPipelineNodePS2SkinGenericPS2AllObjectSetupCallBack(
    RxPS2AllPipeData *ps2AllPipeData,
    RwMatrix **transform,
    RxWorldApplyLightFunc lightingFunc );

extern RwBool
_rxPipelineNodePS2SkinGenericPS2AllInstanceCallBack(
    RxPS2AllPipeData *ps2AllPipeData,
    void **clusterData,
    RwUInt32 numClusters );

extern RwBool
_rxPipelineNodePS2SkinGenericPS2AllMatBridgeCallBack(
    RxPS2AllPipeData *ps2AllPipeData );

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _SKY2_SKINGENERICNODE_H */
