#ifndef _SKINNULL_H
#define _SKINNULL_H

/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/
#include <rwcore.h>
#include <rpworld.h>

#include "rpskin.h"

/*===========================================================================*
 *--- Global Types ----------------------------------------------------------*
 *===========================================================================*/
struct SkinPlatformData
{
    RwV3d *vertices;
    RwV3d *normals;
};

struct SkinGlobalPlatform { RwUInt32 empty; };

/*===========================================================================*
 *--- Private Global Variables ----------------------------------------------*
 *===========================================================================*/
RxGameCubeAllInOneCallBack _rpSkinOldRenderGP;

/*===========================================================================*
 *--- Private Defines -------------------------------------------------------*
 *===========================================================================*/
#define rpSKINMAXNUMBEROFMATRICES 256

/*===========================================================================*
 *--- Private Functions -----------------------------------------------------*
 *===========================================================================*/

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

extern RpAtomic*
_rpSkinBlendBody(RpAtomic *atomic, RwV3d *vertices, RwV3d *normals);

extern void
_rpSkinMainResEntryCB( RwResEntry *resEntry);

extern void
_rpSkinResEntryWaitDone(RwResEntry *resEntry);

extern void*
_rpSkinMatBlendAtomicRender(void *object, RxGameCubePipeData *pipeData );

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _SKINNULL_H */
