/*===========================================================================*
 *-                                                                         -*
 *-  Module  :   G2_BPatchNode.c                                            -*
 *-                                                                         -*
 *-  Purpose :   Hybrid Patch PipeLine for Playstation II.                  -*
 *-              PS2 Manager PowerPipe version.                             -*
 *-                                                                         -*
 *===========================================================================*/

/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/
#include <rwcore.h>
#include <rpworld.h>

#include "rpplugin.h"
#include "rpdbgerr.h"

#include "rppatch.h"

#include "patchatomic.h"
#include "patch.h"
#include "patchsky.h"

#include "G2_BPatch/G2_BPatchNode.h"
#include "G2_BPatch/G2_BPatchData.h"

#include "../../driver/sky2/baasm.h"

/*===========================================================================*
 *--- Private Types ---------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Global Variables ----------------------------------------------*
 *===========================================================================*/
PatchSkyTransforms _rpPatchSkyBPatchTransforms;

/*===========================================================================*
 *--- Private Defines -------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Local Types -----------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Local Global Variables ------------------------------------------------*
 *===========================================================================*/
#if (!defined(DXOYGEN))
static const char rcsid[] __RWUNUSED__ =
    "@@@@(#)$Id: G2_BPatchNode.c,v 1.6 2001/08/29 11:56:23 jamesa Exp $";
#endif /* (!defined(DXOYGEN)) */

/*===========================================================================*
 *--- Local Defines ---------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Local functions -------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private functions -----------------------------------------------------*
 *===========================================================================*/

/*****************************************************************************
 - _rxPipelineNodePS2BPatchPS2ManagerInstanceCallBack
 - Ps2 manager instance call back for rendering generation 2 bezier patches.
 - Inputs :   clusterData - Clusters
              numClusters - Number of cluster
 - Outputs:   RwBool - True on success.
 */
RwBool
_rxPipelineNodePS2BPatchPS2ManagerInstanceCallBack(
    void **clusterData,
    RwUInt32 numClusters __RWUNUSEDRELEASE__ )
{
    /* Cluster expansion. */
    RxPS2Mesh *mesh;
    RxPS2DMASessionRecord *dmaSessionRec;
    RpAtomic *atomic;
    PatchAtomicData *atomicData;

    RWFUNCTION(RWSTRING("_rxPipelineNodePS2BPatchPS2ManagerInstanceCallBack"));
    RWASSERT(NULL != clusterData);
    RWASSERT(2 == numClusters);
    RWASSERT(NULL != clusterData[0]);
    RWASSERT(NULL != clusterData[1]);

    /* Collect the mesh and atomic data. */
    mesh = (RxPS2Mesh *)clusterData[0];
    RWASSERT(NULL != mesh);
    dmaSessionRec = (RxPS2DMASessionRecord *)clusterData[1];
    RWASSERT(NULL != dmaSessionRec);
    atomic = dmaSessionRec->sourceObject.atomic;
    RWASSERT(NULL != atomic);
    atomicData = PATCHATOMICGETDATA(atomic);
    RWASSERT(NULL != atomicData);

    /* Patch lod setup. */
    if(0 == mesh->meshNum)
    {
        RwUInt32 lod;

        /* Call the lod call back. */
        RWASSERT(NULL != atomicData->lod.callback);
        lod = (atomicData->lod.callback)(atomic, atomicData->lod.userData);
        RWASSERT(rpPATCHLODMINVALUE <= lod);
        RWASSERT(rpPATCHLODMAXVALUE >= lod);

        /* Construct the 128 qw lod data. */
        _rpPatchSkyMakeLOD128(_rpPatchSkyLodQW, lod);
    }

    {
        RwUInt128 ltmp = 0;
        RwUInt64 tmp, tmp1;

        /*----------- DMA data Upload -----------------------*/
        sweFinaliseOpenLocalPkt(SWE_PKT_DMA_MODE_CHAIN_TTE  |
                                SWE_PKT_LOCAL | SWE_PKT_VU1 |
                                SWE_PKT_CIRCALLOC, /**/ -5 /**/);
        RWASSERT(NULL != sweLocalPacket);
        /*---------------------------------------------------*/

        SWE_LOCAL_BLOCK_BEGIN();

        /*------- Transfer Information ----------------------*/
        tmp  = ((1l << 28)      | (/**/ 3 /**/));
        tmp1 = ((((0x6cl << 24) | (/**/ 3 /**/ << 16)      |
               ((long) (pipeASymbStaticDataStart))) << 32) |
               ((1l << 24) | (4 << 8) | (4)));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);
        /*---------------------------------------------------*/

        /*------- Patch tesselation -------------------------*/
        SWEADDCONTFAST(_rpPatchSkyLodQW);
        /*---------------------------------------------------*/

        /*------- Small Frustum Clipping information --------*/
        SWEADDCONTFAST(skyCClipVect1);
        SWEADDCONTFAST(skyCClipVect2);
        /*---------------------------------------------------*/

        /*------- Terminate the DMA with an interrupt -------*/
        MAKE128(ltmp, 0l, (0xfl << 28));
        SWEADDCONTFAST(ltmp);
        /*---------------------------------------------------*/

        SWE_LOCAL_BLOCK_END();

        sweFinaliseOpenLocalPkt(SWE_LPS_CONT, 0);
    }

    _rpPatchSkyUpdateMetrics(_rpPatchSkyLodQW, mesh, 1);

    RWRETURN(TRUE);
}

/*****************************************************************************
 - _rpPatchSkyBPatchSetupTransforms
 - Initalises the _rpPatchSkyBPatchTransforms transforms.
 - Inputs :   none.
 - Outputs:   none.
 */
void
_rpPatchSkyBPatchSetupTransforms()
{
    RwUInt32 code;

    RWFUNCTION(RWSTRING("_rpPatchSkyBPatchSetupTransforms"));

    /* Empty the vu code array. */
    for( code = 0; code < VU1CODEARRAYSIZE; code++ )
    {
        _rpPatchSkyBPatchTransforms[code] = &vu1nullTrans;
    }

    _rpPatchSkyBPatchTransforms[TRANSNFOG | TRANSNCL  | TRANSSTRIP | TRANSPER] = &G2_BPatch;
    _rpPatchSkyBPatchTransforms[TRANSFOG  | TRANSNCL  | TRANSSTRIP | TRANSPER] = &G2_BPatch;
    _rpPatchSkyBPatchTransforms[TRANSNFOG | TRANSCLIP | TRANSSTRIP | TRANSPER] = &G2_BPatch;
    _rpPatchSkyBPatchTransforms[TRANSFOG  | TRANSCLIP | TRANSSTRIP | TRANSPER] = &G2_BPatch;

    RWRETURNVOID();
}

/*===========================================================================*
 *--- Plugin Engine Functions -----------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Plugin API Functions --------------------------------------------------*
 *===========================================================================*/
