/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/
#include <rwcore.h>
#include <rpworld.h>

#include "rpplugin.h"
#include "rpdbgerr.h"

#include "noded3d8patchatomicinstance.h"

#include "patchd3d8plain.h"

/*===========================================================================*
 *--- Private Types ---------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Global Variables ----------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Private Defines -------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Local Types -----------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Local Global Variables ------------------------------------------------*
 *===========================================================================*/
#if (!defined(DXOYGEN))
static const char rcsid[] __RWUNUSED__ =
    "@@@@(#)$Id: patchd3d8plain.c,v 1.1 2001/09/28 17:20:10 davidg Exp $";
#endif /* (!defined(DXOYGEN)) */

/*****************************************************************************
 _rwD3D8PatchPipelineNodeInitFn

 Initializes the private data (refinement ON by default)

 Inputs :
 Outputs :
 */
RwBool
_rwD3D8PatchPipelineNodeInitFn( RxPipelineNode *self )
{
    RWFUNCTION(RWSTRING("_rwD3D8PatchPipelineNodeInitFn"));

    if (self)
    {
        RpNodePatchData *data = ((RpNodePatchData *) self->privateData);

        RxNodeDefinition    *instanceDefaultNode;
        RxPipelineNode      *defaultNode;

        data->patchOn = TRUE;
        data->numExtraUVs = 0;
        data->numExtraRGBAs = 0;

        /*
         * Find default render callback
         */
        /* Get the instance node definition */
        instanceDefaultNode = RxNodeDefinitionGetD3D8AtomicAllInOne();
        RWASSERT(NULL != instanceDefaultNode);

        defaultNode = RxPipelineFindNodeByName(RpAtomicGetDefaultInstancePipeline(),
                                                instanceDefaultNode->name, NULL, NULL);

        if (defaultNode != NULL)
        {
            data->renderCallback = RxD3D8AllInOneGetRenderCallBack(defaultNode);
        }
        else
        {
            data->renderCallback = NULL;
        }

        RWRETURN(TRUE);
    }

    RWRETURN(FALSE);
}
