/*
 *  dmphintp.h - delta morph interpolation
 */

#if (!defined(_DMPHINTP_H))
#define _DMPHINTP_H

/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/

#include "rwcore.h"
#include "rpworld.h"

#include "dmphanim.h"

/*===========================================================================*
 *--- Types -----------------------------------------------------------------*
 *===========================================================================*/

/*--- RpDMorphInterpolator --------------------------------------------------
 *
 *  Data holding current position in an animation.
 */
typedef struct rpDMorphInterpolator rpDMorphInterpolator;
struct rpDMorphInterpolator
{
    RpDMorphAnimation  *animation;
    RwReal              animTime;
    rpDMorphFrame     **currFrames;
    RwReal             *currTimes;
    RpAtomicCallBack    loopCallBack;
    void               *loopCallBackData;
};

/*--- rpDMorphAtomicData ---------------------------------------------------
 *
 * This is an extension to RpAtomic.
 */
typedef struct rpDMorphAtomicData rpDMorphAtomicData;
struct rpDMorphAtomicData
{
    /*--- Morph state data ---*/
    RwReal                  *values;

    /*--- Animation interpolator ---*/
    rpDMorphInterpolator    *interpolator;

    /*--- Render callback chaining ---*/
    RpAtomicCallBackRender  defRenderCallBack;
};

/*===========================================================================*
 *--- Global variables ------------------------------------------------------*
 *===========================================================================*/

extern RwInt32 rpDMorphAtomicDataOffset;

/*===========================================================================*
 *--- Macros ----------------------------------------------------------------*
 *===========================================================================*/

/*--- Atomic data ---*/
#define RPDMORPHATOMICGETDATA(atomic)                               \
    ((rpDMorphAtomicData *)(((RwUInt8 *)atomic)+                      \
                          (rpDMorphAtomicDataOffset)))

#define RPDMORPHATOMICGETCONSTDATA(atomic)                          \
    ((const rpDMorphAtomicData *)(((const RwUInt8 *)atomic)+          \
                                (rpDMorphAtomicDataOffset)))

/*===========================================================================*
 *--- Internal plugin functions ---------------------------------------------*
 *===========================================================================*/

extern RwBool   _rpDMorphAtomicPluginAttach(void);

#endif /* _DMPHINTP_H */
