
/****************************************************************************
 *  
 * VRML 2.0 to RW3.0 Converter
 * Copyright (C) 1998 Criterion Technologies
 *
 * Author  : Damian Scallan 
 *
 * Module  : Route.h
 *                                                                         
 * Purpose : Creates route information between nodes
 *          
 ****************************************************************************/

#ifndef ROUTE_H
#define ROUTE_H

/****************************************************************************
 Includes
 */

#include "_rpvrml.h"
#include "abstractnode.h"
#include "types.h"

typedef struct RouteRec RouteRec;
struct RouteRec
{
    AbstractNode *toNode;
    RwChar *toEvent;
};

/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern "C"
{
#endif         /* __cplusplus */

RouteRec *Route_CreateRecord(AbstractNode * toNode,
                             const char *toEvent);
RwBool Route_DestroyRecord(RouteRec * routeRec);
RwBool Route_Set(const RwChar *fromName, const RwChar *eventOutName,
                 const RwChar *toName, const RwChar *eventInName);

AbstractNode *Route_GetFirstCoordInterpolator(AbstractNode *an);
AbstractNode *Route_GetNextCoordInterpolator(AbstractNode *an);

AbstractNode *Route_GetFirstOrientationInterpolator(AbstractNode *an);
AbstractNode *Route_GetNextOrientationInterpolator(AbstractNode *an);
AbstractNode *Route_GetFirstPositionInterpolator(AbstractNode *an);
AbstractNode *Route_GetNextPositionInterpolator(AbstractNode *an);
AbstractNode *Route_GetFirstScaleInterpolator(AbstractNode *an);
AbstractNode *Route_GetNextScaleInterpolator(AbstractNode *an);
AbstractNode *Route_GetFirstScaleOrientInterpolator(AbstractNode *an);
AbstractNode *Route_GetNextScaleOrientInterpolator(AbstractNode *an);
AbstractNode *Anstractnode_GetTimeSensor(AbstractNode *an);

RwBool Route_IsNodeStatic(AbstractNode *an);

#ifdef    __cplusplus
}
#endif         /* __cplusplus */

#endif         /* ROUTE_H */
