
/****************************************************************************
 *  
 * VRML 2.0 to RW3.0 Converter
 * Copyright (C) 1997 Criterion Technologies
 *
 * Author  : Damian Scallan 
 *
 * Module  : LogFile.h
 *                                                                         
 * Purpose : Used by the Converter to manage the debug log in RWDEBUG builds.
 *
 *                                                                         
 ****************************************************************************/

#ifndef LOGFILE_H
#define LOGFILE_H

/****************************************************************************
 Includes
 */

#include <stdio.h>
#include "_rpvrml.h"

/****************************************************************************
 Global defines
 */

#ifdef RWDEBUG
#define LOGOPEN(name) vrmlLogOpen(name);
#define LOGMSG(x) vrmlLogMsg x
#define LOGCLOSE() vrmlLogClose()
#define LOGINCINDENT() vrmlLogIncIndent()
#define LOGDECINDENT() vrmlLogDecIndent()
#else /* RWDEBUG */
#define LOGOPEN(name) NULL
#define LOGMSG(x)              /* Nothing */
#define LOGCLOSE()             /* Nothing */
#define LOGINCINDENT()         /* Nothing */
#define LOGDECINDENT()         /* Nothing */
#endif /* RWDEBUG */

/****************************************************************************
 Global Types
 */

 /****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern          "C"
{
#endif         /* __cplusplus */

#ifdef RWDEBUG
    RwStream       *vrmlLogOpen(const RwChar *name);
    void            vrmlLogMsg(const RwChar *format,...);
    void            vrmlLogClose(void);
    void            vrmlLogIncIndent(void);
    void            vrmlLogDecIndent(void);
#endif         /* RWDEBUG */

#ifdef    __cplusplus
}
#endif         /* __cplusplus */

#endif         /* LOGFILE_H */
