#if (!defined(SKINPRIV_H))
#define SKINPRIV_H

#ifdef    _cplusplus
extern              "C"
{
#endif                          /* _cplusplus */

extern RwBool       _rpSkinMBInitAtomic(RpAtomic * atomic);
extern RwBool       _rpSkinMBPluginAttach(void);
extern void         _rpSkinMBDestroyAtomic(RpSkin * pSkin);

#ifdef    _cplusplus
}
#endif                          /* _cplusplus */


typedef struct RpSkinAtomicGlobalVars RpSkinAtomicGlobalVars;

struct RpSkinAtomicGlobalVars
{
        RwInt32     engineOffset;       /* Offset into global data */
        RwInt32     atomicOffset;       /* Offset into atomic data */
        RwFreeList *SkinFreeList;       /* Free list for RpSkins */
        void       *SkinMatrixCacheUnaligned;   /* Unaligned pointer for aligned SkinMatrixCache */
        RwMatrix   *SkinMatrixCache;            /* Cache of matrices used for skinning */
        RpSkin     *SkinMatrixCacheSkin;        /* Current matrix cache data is for this Skin */
        RwUInt16    SkinMatrixCacheRenderFrame; /* And was cached on this frame */
};

extern RpSkinAtomicGlobalVars RpSkinAtomicGlobals;

#define RpV3dInterpolate(o, a, s, b)                            \
MACRO_START                                                     \
{                                                               \
    (o)->x = (((a)->x) + ((s)) * (((b)->x) - ((a)->x)));        \
    (o)->y = (((a)->y) + ((s)) * (((b)->y) - ((a)->y)));        \
    (o)->z = (((a)->z) + ((s)) * (((b)->z) - ((a)->z)));        \
}                                                               \
MACRO_STOP

#define RPSKINATOMICGETDATA(atomic)                     \
     ((RpSkin **)(((RwUInt8 *)atomic) +                 \
                  RpSkinAtomicGlobals.atomicOffset))

#define RPSKINATOMICGETCONSTDATA(atomic)                \
     ((const RpSkin **)(((const RwUInt8 *)atomic) +     \
                  RpSkinAtomicGlobals.atomicOffset))

#define SkinMatrixMultiplyMacro5900(_pOutMatrix, _pMat1, _pMat2)  \
    asm volatile ("                                               \
    .set noreorder                              ;                 \
    lqc2 vf1, 0(%0)                             ;                 \
    lqc2 vf2, 16(%0)                            ;                 \
    lqc2 vf3, 32(%0)                            ;                 \
    lqc2 vf4, 48(%0)                            ;                 \
                                                                  \
    lqc2 vf5, 0(%1)                             ;                 \
    lqc2 vf6, 16(%1)                            ;                 \
    lqc2 vf7, 32(%1)                            ;                 \
    lqc2 vf8, 48(%1)                            ;                 \
                                                                  \
    vmulax.xyzw  ACC, vf5, vf1                  ;                 \
    vmadday.xyzw ACC, vf6, vf1                  ;                 \
    vmaddz.xyzw  vf9, vf7, vf1                  ;                 \
                                                                  \
    vmulax.xyzw  ACC, vf5, vf2                  ;                 \
    vmadday.xyzw ACC, vf6, vf2                  ;                 \
    vmaddz.xyzw  vf10, vf7, vf2                 ;                 \
                                                                  \
    vmulax.xyzw  ACC, vf5, vf3                  ;                 \
    vmadday.xyzw ACC, vf6, vf3                  ;                 \
    vmaddz.xyzw  vf11, vf7, vf3                 ;                 \
                                                                  \
    vmulax.xyzw  ACC, vf5, vf4                  ;                 \
    vmadday.xyzw ACC, vf6, vf4                  ;                 \
    vmaddaz.xyzw ACC, vf7, vf4                  ;                 \
    vmaddw.xyzw  vf12, vf8, vf0                 ;                 \
                                                                  \
    sqc2 vf9, 0(%2)                             ;                 \
    sqc2 vf10, 16(%2)                           ;                 \
    sqc2 vf11, 32(%2)                           ;                 \
    sqc2 vf12, 48(%2)                           ;                 \
    .set reorder                                                  \
    " : : "r" (_pMat1), "r" (_pMat2), "r" (_pOutMatrix)           \
        : "cc", "memory" )


#endif /* (!defined(SKINPRIV_H)) */
