#ifndef _SKINLINK_H
#define _SKINLINK_H

#include <rwcore.h>
#include <rpworld.h>
#include <rpskin310.h>

#include "skinpriv.h"

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

/*--- Linked types --------------------------------------*/
typedef RpSkin * (* _rpSkinLinkAtomicGetSkin)(RpAtomic *pAtomic);
typedef RpSkinAtomicGlobalVars _rpSkinLinkAtomicGlobals;

#if (defined(SKY2_DRVMODEL_H))
typedef void (* _rpSkinLinkMBWeightsInstancing)(const RpMesh *mesh, RpSkin *pSkin, RwReal *destMBI);
typedef RwMatrix * (* _rpSkinLinkMBMatUpdating)(RpAtomic *atomic, RpSkin *pSkin);
typedef RwBool (* _rpSkinLinkPS2ManagerInstanceCallBack)(void **clusterData, RwUInt32 numClusters);
typedef void * RWALIGN(_rpSkinLinkVU1Transform[VU1CODEARRAYSIZE], rwFRAMEALIGNMENT);
#endif /* (defined(SKY2_DRVMODEL_H)) */

/*--- Linked struct -------------------------------------*/
typedef struct _rpSkinLink _rpSkinLink;
struct _rpSkinLink
{
    /*--- Function pointers ---*/
    _rpSkinLinkAtomicGetSkin                skinAtomicGetSkin;
    _rpSkinLinkAtomicGlobals               *skinAtomicGlobals;
#if (defined(SKY2_DRVMODEL_H))
    _rpSkinLinkMBWeightsInstancing          skinMBWeightsInstancing;
    _rpSkinLinkMBMatUpdating                skinMBMatUpdating;
    _rpSkinLinkPS2ManagerInstanceCallBack   skinPS2ManagerInstanceCallBack;
    _rpSkinLinkVU1Transform                *skinVU1Transform;
#endif /* (defined(SKY2_DRVMODEL_H)) */
};

/*--- Linking type --------------------------------------*/
typedef _rpSkinLink * (* _rpSkinLinkPopulateCallBack)(_rpSkinLink *skinLink);

/*--- Linking struct ------------------------------------*/
typedef struct _rpSkinLinkCallBack _rpSkinLinkCallBack;
struct _rpSkinLinkCallBack
{
    _rpSkinLinkPopulateCallBack skinLinkPopulateCallBack;
};

/*--- Linked function -----------------------------------*/
extern _rpSkinLink *
_rpSkinLinkPopulate(_rpSkinLink *skinLink);

#define RPSKINLINKGETDATA(engineInstance)                   \
     ((_rpSkinLinkCallBack *)(((RwUInt8 *)engineInstance) + \
                  RwEngineGetPluginOffset(rwID_SKINPLUGIN)))

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _SKINLINK_H */
