/****************************************************************************
 *                                                                          *
 *  Module  :   skinlink.c                                                  *
 *                                                                          *
 *  Purpose :   Allows plugins to play together                             *
 *                                                                          *
 ****************************************************************************/

/****************************************************************************
 Includes
 */
#include <rwcore.h>
#include <rpworld.h>
#include <rpskin310.h>
#include <rpdbgerr.h>

#include "skinpriv.h"
#include "skinlink.h"

#if (defined(SKY2_DRVMODEL_H))
#include "matblend.h"
#include "SKY2_SkinGeneric/SkinGeneric.h"
#endif /* (defined(SKY2_DRVMODEL_H)) */

/****************************************************************************
 Functions
 */
_rpSkinLink *
_rpSkinLinkPopulate(_rpSkinLink *skinLink)
{
    RWFUNCTION(RWSTRING("_rpSkinLinkPopulate"));
    RWASSERT(NULL != skinLink);

    skinLink->skinAtomicGetSkin              = RpSkinAtomicGetSkin;
    skinLink->skinAtomicGlobals              = &RpSkinAtomicGlobals;
#if (defined(SKY2_DRVMODEL_H))
    skinLink->skinMBWeightsInstancing        = _rpSkinMBWeightsInstancing;
    skinLink->skinMBMatUpdating              = _rpSkinMBMatUpdating;
    skinLink->skinPS2ManagerInstanceCallBack = RxPipelineNodePS2SkinGenericPS2ManagerInstanceCallBack;
    skinLink->skinVU1Transform               = &skySkinVU1Transforms;
#endif /* (defined(SKY2_DRVMODEL_H)) */

    RWRETURN(skinLink);
}
