/****************************************************************************
 *                                                                          *
 *  Module  :   bbtp.h                                                      *
 *                                                                          *
 *  Purpose :   Tools for Bernstein Bezier Triangular Patch                 *
 *                                                                          *
 ****************************************************************************/

#ifndef BBTP_H
#define BBTPL_H

#include <rwcore.h>


/* ordinates -
 * elevation above domain triangle, used for BBTP patch */
typedef struct BBTPOrdinates BBTPOrdinates;
struct BBTPOrdinates
{
    RwReal  b210, b201,
            b120, b111, b102,
            b021, b012;
};

/* control points -
 * vector location above domain triangle, used for BBTP surface */

typedef struct BBTPControlPoints BBTPControlPoints;
struct BBTPControlPoints
{
    RwV3d   b210, b201,
            b120, b111, b102,
            b021, b012,
            b300, b030, b003;

};

#ifdef    __cplusplus
extern              "C"
{
#endif                          /* __cplusplus */

/*****************************************************************************
 PATCH code
 */
extern RwReal
_rtbbtpPatchEvaluate(BBTPOrdinates *ord, RwReal a, RwReal b, RwReal c);

extern RwReal
_rtbbtpComputeOrdinates(RwV3d *vpV0, RwV3d *vpV1, RwV3d *vpN0,
                        RwV3d *normalDir);

extern RwReal
_rt_rtbbtpComputeOrdinatesSlow(RwV3d *vpV0, RwV3d *vpV1, RwV3d *vpN0,
                         RwV3d *normalDir);
    
/*****************************************************************************
 SURFACE code
 */

extern void
_rtbbtpSurfaceEvaluate(RwV3d *res, BBTPControlPoints *cps,
                    RwReal a, RwReal b, RwReal c);

extern RwV3d
_rt_rtbbtpComputeControlPointsOld(RwV3d *v0, RwV3d *n0, RwV3d *v1, RwV3d *n1);

extern RwV3d
_rtbbtpComputeControlPoints(RwV3d *v0, RwV3d *n0, RwV3d *v1,
                         RwV3d *n1);

extern void
_rtbbtpGenerateOrdinates(BBTPOrdinates *ord, RwV3d *verts, RwV3d *norms);

extern void
_rtbbtpGenerateControlPoints(BBTPControlPoints *cps, RwV3d *v, RwV3d *n);

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

#endif /* BBTP_H */

