/****************************************************************************
 *                                                                          *
 *  Module  :   patchogl.c                                                  *
 *                                                                          *
 *  Purpose :   OpenGL specific code for patches.                           *
 *                                                                          *
 ****************************************************************************/

/****************************************************************************
 Includes
 */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>

/* RW includes */
#include "rpplugin.h"
#include <rpdbgerr.h>
#include <rwcore.h>
#include <rpworld.h>
#include <rtbezpat.h>

#include "rppatch310.h"
#include "patchvar.h"
#include "patchgen.h"
#include "patchexp.h"

#include "nodeOpenGLPatchAtomicInstance.h"

#include "patchogl.h"

#if (!defined(DOXYGEN))
static const char   rcsid[] __RWUNUSED__ =
    "@@@@(#)$Id: patchogl.c,v 1.6 2001/09/25 15:37:31 iestynb Exp $";
#endif /* (!defined(DOXYGEN)) */

/****************************************************************************
 Local Defines
 */

/****************************************************************************
 Globals (across program)
 */

/****************************************************************************
 Functions
 */

RxPipeline         *
_rpPatchPipelineCreate(void)
{
    RxPipeline         *pipe;

    RWFUNCTION(RWSTRING("_rpPatchPipelineCreate"));

    pipe = RxPipelineCreate();
    if (pipe)
    {
        RxLockedPipe       *lpipe;

        pipe->pluginId = rwID_PATCHPLUGIN;

        if ((lpipe = RxPipelineLock(pipe)) != NULL)
        {
            RxPipelineNode     *node;

            lpipe = RxLockedPipeAddFragment(lpipe, NULL,
                                            RxNodeDefinitionGetOpenGLPatchAtomicInstance
                                            (),
                                            RxNodeDefinitionGetAtomicEnumerateLights
                                            (),
                                            RxNodeDefinitionGetMaterialScatter
                                            (), NULL);

            /* Make sure indices and OpenGL specific data clusters propagate to
             * the end of the pipeline, such that they can be passed to the
             * subsequent material pipelines.
             */
            node =
                RxPipelineFindNodeByName(lpipe,
                                         RxNodeDefinitionGetMaterialScatter
                                         ()->name, NULL, NULL);
            RxPipelineNodeRequestCluster(lpipe, node, &RxClIndices);
            RxPipelineNodeRequestCluster(lpipe, node,
                                         &RxClOpenGLExtensionData);

            lpipe = RxLockedPipeUnlock(lpipe);

            RWASSERT(pipe == (RxPipeline *) lpipe);
        }
    }

    RWRETURN(pipe);
}
