#ifndef EFFECTPIPESD3D8_H
#define EFFECTPIPESD3D8_H

/*===========================================================================*
 *--- Include files ---------------------------------------------------------*
 *===========================================================================*/
#include <rwcore.h>
#include <rpworld.h>

/*===========================================================================*
 *--- Defines ---------------------------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Types -----------------------------------------------------------------*
 *===========================================================================*/
struct MatFXDualData
{
    RwTexture          *texture;
    RwBlendFunction     srcBlendMode;
    RwBlendFunction     dstBlendMode;

    /*--- device specific ---*/
};

struct MatFXBumpMapData
{
    RwFrame   *frame;
    RwTexture *texture;
    RwTexture *bumpTexture;
    RwReal    coef;
    RwReal    invBumpWidth;
};

/*===========================================================================*
 *--- Public Global Functions -----------------------------------------------*
 *===========================================================================*/
extern RwBool _rwD3D8TextureHasAlpha(const RwTexture *texture);

/*===========================================================================*
 *--- Public Global Variables -----------------------------------------------*
 *===========================================================================*/

/*===========================================================================*
 *--- Functions -------------------------------------------------------------*
 *===========================================================================*/

#endif /* EFFECTPIPESD3D8_H */
