/*
 * Copyright (c) Criterion Software Limited
 */

/**********************************************************************
 *
 * File :     rpmemlk.h
 *
 * Abstract : Memory leak tracking support
 *
 **********************************************************************
 *
 * This file is a product of Criterion Software Ltd.
 *
 * This file is provided as is with no warranties of any kind and is
 * provided without any obligation on Criterion Software Ltd. or
 * Canon Inc. to assist in its use or modification.
 *
 * Criterion Software Ltd. will not, under any
 * circumstances, be liable for any lost revenue or other damages arising
 * from the use of this file.
 *
 * Copyright (c) 1998 Criterion Software Ltd.
 * All Rights Reserved.
 *
 * RenderWare is a trademark of Canon Inc.
 *
 ************************************************************************/

#ifndef RPMEMLK_H
#define RPMEMLK_H

/**
 * \defgroup rpmemlk RpMemLeak
 * \ingroup retired
 *
 * Memory Leak Tracking Plug-In for RenderWare.
 */

/*--- Include files ---*/
#include <rwcore.h>

#include "rpmemlk.rpe"         /* automatically generated header file */

/*--- Global Structures ---*/

/**
 * \ingroup rpmemlk
 * \typedef RpMemLeakCallBack 
 * typedef for a callback e.g for 
 * reporting memory allocations.
 *
 * \param  *addr   pointer to a memory block.
 * \param  size   size of memory block.
 *
 * \see RpMemLeakEndTrace
 *
 * */
typedef void   *(*RpMemLeakCallBack) (void *addr, size_t size);

typedef struct RpMemLeakBlockDescriptor RpMemLeakBlockDescriptor;
/**
 * \ingroup rpmemlk
 * \struct RpMemLeakBlockDescriptor 
 *  structure describing a a memory allocation 
 */
struct RpMemLeakBlockDescriptor
{
    void           *addr; /**< pointer to allocated memory */
    size_t          size; /**< size of allocated memory */
};

typedef struct RpMemLeakList RpMemLeakList;
/**
 * \ingroup rpmemlk
 * \struct RpMemLeakList 
 * structure listing memory allocations 
 */
struct RpMemLeakList
{
    RpMemLeakBlockDescriptor *memBlocks; /**< array of memory allocations */
    RwUInt32        numBlocks;           /**< occupied length of array */
    RwUInt32        numAllocatedBlocks;  /**< allocated length for array */
};

/*--- Constants ---*/

/*--- Plugin API Functions ---*/

#ifdef    __cplusplus
extern          "C"
{
#endif         /* __cplusplus */

extern RwBool          RpMemLeakPluginAttach(void);
extern RpMemLeakList  *RpMemLeakStartTrace(RpMemLeakList * list);
extern RpMemLeakList  *RpMemLeakEndTrace(RpMemLeakList * list,
                                         RpMemLeakCallBack callback);

#ifdef    __cplusplus
}
#endif         /* __cplusplus */

#endif         /* RPMEMLK_H */

