
/***************************************************************************
 *                                                                         *
 * Module  : rtsplpvs.h                                                    *
 *                                                                         *
 * Purpose : To generate pvs data for a world froma spline                 *
 *                                                                         *
 **************************************************************************/

#ifndef RTSPLINEPVS_H
#define RTSPLINEPVS_H

/**
 * \defgroup rtsplinepvs RtSplinePVS
 * \ingroup rttool
 * 
 * Spline Pvs Toolkit for Renderware.
 */

/****************************************************************************
 Includes
 */

#include "rwcore.h"
#include "rpworld.h"
#include "rpspline.h"

/* RWPUBLIC */

/****************************************************************************
 Defines
 */

/****************************************************************************
 Global Types
 */

/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern              "C"
{
#endif                          /* __cplusplus */

extern RpWorld *
RtSplinePVSCreate(RpWorld * world,
                  RwRaster * raster, RwRaster * zraster,
                  RwReal mindist, RwReal maxdist,
                  RpSpline *spline, RwInt32 samples);

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

/* RWPUBLICEND */

#endif                          /* RTSPLINEPVS_H */
