#ifndef RTIEEEF_H
#define RTIEEEF_H

/**
 * \defgroup rtieeef RtIEEEf
 * \ingroup rttool
 *
 * Single precison IEEE float format mathematics library
 */

/*	$OpenBSD: math_private.h,v 1.5 2000/03/02 00:29:50 todd Exp $	*/
/*
 * ====================================================
 * Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
 *
 * Developed at SunPro, a Sun Microsystems, Inc. business.
 * Permission to use, copy, modify, and distribute this
 * software is freely granted, provided that this notice 
 * is preserved.
 * ====================================================
 */

#include <math.h>
#include <rwcore.h>

#include "rtieeef.rpe"         /* automatically generated header file */

/* c.f. math.h */

#define RTIEEEF_ERANGE 43

#if (defined(__cplusplus))
extern              "C"
{
#endif                          /* (defined(__cplusplus)) */

/* API */

extern float        RtIEEEacosf(float x);
extern float        RtIEEEacoshf(float x);
extern float        RtIEEEasinf(float x);
extern float        RtIEEEasinhf(float x);
extern float        RtIEEEatan2f(float y, float x);
extern float        RtIEEEatanf(float x);
extern float        RtIEEEatanhf(float x);
extern float        RtIEEEcbrtf(float x);
extern float        RtIEEEceilf(float x);
extern float        RtIEEEcopysignf(float x, float y);
extern float        RtIEEEcosf(float x);
extern float        RtIEEEcoshf(float x);
extern float        RtIEEEerfcf(float x);
extern float        RtIEEEerff(float x);
extern float        RtIEEEexpf(float x);
extern float        RtIEEEexpm1f(float x);
extern float        RtIEEEfabsf(float x);
extern int          RtIEEEfinitef(float x);
extern float        RtIEEEfloorf(float x);
extern float        RtIEEEfmodf(float x, float y);
extern float        RtIEEEfrexpf(float x, int *eptr);
extern float        RtIEEEhypotf(float x, float y);
extern int          RtIEEEilogbf(float x);
extern int          RtIEEEisinf(double x);
extern int          RtIEEEisinff(float x);
extern int          RtIEEEisnanf(float x);
extern float        RtIEEEj0f(float x);
extern float        RtIEEEj1f(float x);
extern float        RtIEEEjnf(int n, float x);
extern float        RtIEEEldexpf(float value, int exp);
extern float        RtIEEElog10f(float x);
extern float        RtIEEElog1pf(float x);
extern float        RtIEEElogbf(float x);
extern float        RtIEEElogf(float x);
extern float        RtIEEEmodff(float x, float *iptr);
extern float        RtIEEEnextafterf(float x, float y);
extern float        RtIEEEpowf(float x, float y);
extern int          RtIEEErem_pio2f(float x, float *y);
extern float        RtIEEEremainderf(float x, float p);
extern float        RtIEEErintf(float x);
extern float        RtIEEEscalbf(float x, float fn);
extern float        RtIEEEscalbnf(float x, int n);
extern float        RtIEEEsignificandf(float x);
extern float        RtIEEEsinf(float x);
extern float        RtIEEEsinhf(float x);
extern float        RtIEEEsqrtf(float x);
extern float        RtIEEEtanf(float x);
extern float        RtIEEEtanhf(float x);
extern float        RtIEEEy0f(float x);
extern float        RtIEEEy1f(float x);
extern float        RtIEEEynf(int n, float x);

#if (defined(__cplusplus))
}
#endif                          /* (defined(__cplusplus)) */

#if (defined(__cplusplus))
extern              "C"
{

#endif                          /* (defined(__cplusplus)) */

/* SPI */

extern int          _rtIEEEferrno;

extern float        _rtIEEEacosf(float x);
extern float        _rtIEEEacoshf(float x);
extern float        _rtIEEEasinf(float x);
extern float        _rtIEEEatan2f(float y, float x);
extern float        _rtIEEEatanhf(float x);
extern float        _rtIEEEcosf(float x, float y);
extern int          _rtIEEErem_pio2f(float *x, float *y,
                                     int e0, int nx,
                                     int prec, const int *ipio2);
extern float        _rtIEEEsinf(float x, float y, int iy);
extern double       _rtIEEEstandard(double x, double y, int type);
extern float        _rtIEEEtanf(float x, float y, int iy);

#if (defined(__cplusplus))
}
#endif                          /* (defined(__cplusplus)) */

#endif                          /* RTIEEE_H */
