/***************************************************************************
 *                                                                         *
 * Module  : drvmodel.h (null)                                             *
 *                                                                         *
 * Purpose : Driver model description (device specific vertices/polys)     *
 *                                                                         *
 **************************************************************************/

/* RWPUBLIC */
#ifndef NULL_DRVMODEL_H
#define NULL_DRVMODEL_H

/**
 * \defgroup drivernull NULL
 * \ingroup rwcore
 *
 * NULL drivers
 */

/**
 * \defgroup nullunsupported Unsupported NULL Functions
 * \ingroup drivernull
 *
 * Unsupported functions
 */

/* RWPUBLICEND */

/****************************************************************************
 Includes
 */

#include "batypes.h"
#include "bacolor.h"

/* RWPUBLIC */

/****************************************************************************
 Defines
 */

#define RwFastRealToUInt32(X) ((RwInt32)(X))

#if (!defined(_MSC_VER))
#define IsBadReadPtr(_lp, _ucb ) \
  (NULL != (_lp))
#else /* (defined(_MSC_VER)) */
#include <windows.h>
/*
 * IsBadReadPtr() is defined in
 * /Program Files/Microsoft Visual Studio/VC98/Include/WINBASE.H
 */
#endif /* (defined(_MSC_VER)) */

/* Set true depth information (for fogging, eg) */
#define RwIm2DVertexSetCameraX(vert, camx)      ((vert)->camera.x = (camx))
#define RwIm2DVertexSetCameraY(vert, camy)      ((vert)->camera.y = (camy))
#define RwIm2DVertexSetCameraZ(vert, camz)      ((vert)->camera.z = (camz))
#define RwIm2DVertexSetRecipCameraZ(vert, recipz)     ((vert)->recipZ = (recipz))

#define RwIm2DVertexGetCameraX(vert)            ((vert)->camera.x)
#define RwIm2DVertexGetCameraY(vert)            ((vert)->camera.y)
#define RwIm2DVertexGetCameraZ(vert)            ((vert)->camera.z)
#define RwIm2DVertexGetRecipCameraZ(vert)             ((vert)->recipZ)

/* Set screen space coordinates in a device vertex */
#define RwIm2DVertexSetScreenX(vert, scrnx)     ((vert)->screen.x = (scrnx))
#define RwIm2DVertexSetScreenY(vert, scrny)     ((vert)->screen.y = (scrny))
#define RwIm2DVertexSetScreenZ(vert, scrnz)     ((vert)->screen.z = (scrnz))
#define RwIm2DVertexGetScreenX(vert)            ((vert)->screen.x)
#define RwIm2DVertexGetScreenY(vert)            ((vert)->screen.y)
#define RwIm2DVertexGetScreenZ(vert)            ((vert)->screen.z)

/* Set texture coordinates in a device vertex */
#define RwIm2DVertexSetU(vert, u, recipz)       ((vert)->texU = (u))
#define RwIm2DVertexSetV(vert, v, recipz)       ((vert)->texV = (v))
#define RwIm2DVertexGetU(vert)                  ((vert)->texU)
#define RwIm2DVertexGetV(vert)                  ((vert)->texV)

/* Modify the luminance stuff */
#define RwIm2DVertexSetRealRGBA(vert, r, g, b, a)   \
        {                                           \
            ((vert)->col.red   = (r));              \
            ((vert)->col.green = (g));              \
            ((vert)->col.blue  = (b));              \
            ((vert)->col.alpha = (a));              \
        }
#define RwIm2DVertexSetIntRGBA(vert, r, g, b, a)    \
        {                                           \
            ((vert)->col.red   = (RwReal)(r));      \
            ((vert)->col.green = (RwReal)(g));      \
            ((vert)->col.blue  = (RwReal)(b));      \
            ((vert)->col.alpha = (RwReal)(a));      \
        }

#define RwIm2DVertexGetRed(vert)                ((RwUInt32)((vert)->col.red))
#define RwIm2DVertexGetGreen(vert)              ((RwUInt32)((vert)->col.green))
#define RwIm2DVertexGetBlue(vert)               ((RwUInt32)((vert)->col.blue))
#define RwIm2DVertexGetAlpha(vert)              ((RwUInt32)((vert)->col.alpha))

#define RwIm2DVertexCopyRGBA(dst, src)              \
        {                                           \
            ((dst)->col.red   = (src)->col.red);    \
            ((dst)->col.green = (src)->col.green);  \
            ((dst)->col.blue  = (src)->col.blue);   \
            ((dst)->col.alpha = (src)->col.alpha);  \
        }

/* Clipper stuff */
#define RwIm2DVertexClipRGBA(out, interp, near, far)                                        \
        {                                                                                   \
            (out)->col.red   = RWSHADCLIP((interp), (near)->col.red,   (far)->col.red);     \
            (out)->col.green = RWSHADCLIP((interp), (near)->col.green, (far)->col.green);   \
            (out)->col.blue  = RWSHADCLIP((interp), (near)->col.blue,  (far)->col.blue);    \
            (out)->col.alpha = RWSHADCLIP((interp), (near)->col.alpha, (far)->col.alpha);   \
        }

/* LEGACY-SUPPORT macros */
#define RWIM2DVERTEXSetCameraX(vert, camx)  RwIm2DVertexSetCameraX(vert, camx)
#define RWIM2DVERTEXSetCameraY(vert, camy)  RwIm2DVertexSetCameraY(vert, camy)
#define RWIM2DVERTEXSetCameraZ(vert, camz)  RwIm2DVertexSetCameraZ(vert, camz)
#define RWIM2DVERTEXSetRecipCameraZ(vert, recipz) \
    RwIm2DVertexSetRecipCameraZ(vert, recipz)
#define RWIM2DVERTEXGetCameraX(vert)        RwIm2DVertexGetCameraX(vert)
#define RWIM2DVERTEXGetCameraY(vert)        RwIm2DVertexGetCameraY(vert)
#define RWIM2DVERTEXGetCameraZ(vert)        RwIm2DVertexGetCameraZ(vert)
#define RWIM2DVERTEXGetRecipCameraZ(vert)   RwIm2DVertexGetRecipCameraZ(vert)
#define RWIM2DVERTEXSetScreenX(vert, scrnx) RwIm2DVertexSetScreenX(vert, scrnx)
#define RWIM2DVERTEXSetScreenY(vert, scrny) RwIm2DVertexSetScreenY(vert, scrny)
#define RWIM2DVERTEXSetScreenZ(vert, scrnz) RwIm2DVertexSetScreenZ(vert, scrnz)
#define RWIM2DVERTEXGetScreenX(vert)        RwIm2DVertexGetScreenX(vert)
#define RWIM2DVERTEXGetScreenY(vert)        RwIm2DVertexGetScreenY(vert)
#define RWIM2DVERTEXGetScreenZ(vert)        RwIm2DVertexGetScreenZ(vert)
#define RWIM2DVERTEXSetU(vert, u, recipz)   RwIm2DVertexSetU(vert, u, recipz)
#define RWIM2DVERTEXSetV(vert, v, recipz)   RwIm2DVertexSetV(vert, v, recipz)
#define RWIM2DVERTEXGetU(vert)              RwIm2DVertexGetU(vert)
#define RWIM2DVERTEXGetV(vert)              RwIm2DVertexGetV(vert)
#define RWIM2DVERTEXSetRealRGBA(vert, red, green, blue, alpha) \
    RwIm2DVertexSetRealRGBA(vert, red, green, blue, alpha)
#define RWIM2DVERTEXSetIntRGBA(vert, red, green, blue, alpha)  \
    RwIm2DVertexSetIntRGBA(vert, red, green, blue, alpha)
#define RWIM2DVERTEXGetRed(vert)            RwIm2DVertexGetRed(vert)
#define RWIM2DVERTEXGetGreen(vert)          RwIm2DVertexGetGreen(vert)
#define RWIM2DVERTEXGetBlue(vert)           RwIm2DVertexGetBlue(vert)
#define RWIM2DVERTEXGetAlpha(vert)          RwIm2DVertexGetAlpha(vert)
#define RWIM2DVERTEXCopyRGBA(dst, src)      RwIm2DVertexCopyRGBA(dst, src)
#define RWIM2DVERTEXClipRGBA(o, i, n, f)    RwIm2DVertexClipRGBA(o, i, n, f)

/****************************************************************************
 Global Types
 */

/* Define types used */

typedef struct _RwNull2DVertex RwNull2DVertex;
struct _RwNull2DVertex
{
    RwV3d           screen;  /* Screen space coordinate */
    RwRGBAReal      col;  /* Vertex color */
    RwReal          texU, texV;  /* Texture coordinates */
    RwReal          recipZ;  /* Reciprocal Z */
    RwV3d           camera;  /* Camera space coordinate */
};

/**
 * \ingroup drivernull
 * \typedef RwIm2DVertex
 * Typedef for a RenderWare Graphics Immediate Mode 2D Vertex
 */
typedef RwNull2DVertex  RwIm2DVertex;
/* LEGACY-SUPPORT macro */
#define RWIM2DVERTEX    RwIm2DVertex

/**
 * \ingroup drivernull
 * \typedef RxVertexIndex
 * Typedef for a RenderWare Graphics PowerPipe Immediate Mode Vertex
 */
typedef RwUInt16        RxVertexIndex;

/**
 * \ingroup drivernull
 * \typedef RwImVertexIndex
 * Typedef for a RenderWare Graphics Immediate Mode Vertex
 */
typedef RxVertexIndex   RwImVertexIndex;
/* LEGACY-SUPPORT macro */
#define RWIMVERTEXINDEX RwImVertexIndex

#endif /* NULL_DRVMODEL_H */
/* RWPUBLICEND */
