
/****************************************************************************
 *
 * This file is a product of Criterion Software Ltd.
 *
 * This file is provided as is with no warranties of any kind and is
 * provided without any obligation on Criterion Software Ltd.
 * or Canon Inc. to assist in its use or modification.
 *
 * Criterion Software Ltd. and Canon Inc. will not, under any
 * circumstances, be liable for any lost revenue or other damages
 * arising from the use of this file.
 *
 * Copyright (c) 2001 Criterion Software Ltd.
 * All Rights Reserved.
 *
 */

/****************************************************************************
 *                                                                         
 * prtcls1.h
 *
 * Copyright (C) 2001 Criterion Technologies.
 *
 * Original author: Nicolas Vale.
 *                                                                         
 * Purpose: To illustrate how to load or create a particle clump, 
 *          and how it's different properties can be adjusted to produce
 *          different particle effects.
 *                         
 ****************************************************************************/

#ifndef PRTCLS1_H
#define PRTCLS1_H

#include "rwcore.h"
#include "rpworld.h"

#define NUMSYSTEMS (4)
#define NUMTEXTURES (6)

extern RpWorld *World;
extern RwCamera *Camera;

extern RwInt32 ParticlesCurrentSystem;

extern const RwChar *ParticleTextureNames[];
extern RwInt32 ParticlesCurrentTexture;

extern RwInt32 ParticlesNumber;

extern RwReal ParticlesEmitterWidth; 
extern RwReal ParticlesEmitterLength; 
extern RwReal ParticlesEmitterAngle;

extern RwReal ParticlesSize;
extern RwReal ParticlesGrowth;
extern RwReal ParticlesAspectRatio;

extern RwReal ParticlesMinSpeed;
extern RwReal ParticlesMaxSpeed;
extern RwReal ParticlesDamping;

extern RwReal ParticlesFlightTime;
extern RwV3d ParticlesForce;

extern RwInt32 ParticlesStartColor;
extern RwInt32 ParticlesStartAlpha;
extern RwInt32 ParticlesEndColor;
extern RwInt32 ParticlesEndAlpha;

#ifdef    __cplusplus
extern "C"
{
#endif /* __cplusplus */

extern RwBool ParticlesInitialize(RpWorld *world);
extern RwBool ParticlesTerminate(void);

extern RwBool ParticlesUpdate(RwReal timeStep);

extern void ParticlesRotateEmitter(RwReal angleX, RwReal angleY);
extern void ParticlesZTranslateEmitter(RwReal zDelta);

extern RwBool ParticlesSetSystemCallback(RwBool testEnable);
extern RwBool ParticlesSetTextureCallback(RwBool testEnable);
extern RwBool ParticlesSetNumberCallback(RwBool testEnable);
extern RwBool ParticlesSetEmitterAngleCallback(RwBool testEnable);
extern RwBool ParticlesSetEmitterSizeCallback(RwBool testEnable);
extern RwBool ParticlesSetSizeCallback(RwBool testEnable);
extern RwBool ParticlesSetSpeedCallback(RwBool testEnable);
extern RwBool ParticlesSetFlightTimeCallback(RwBool testEnable);
extern RwBool ParticlesSetForceCallback(RwBool testEnable);
extern RwBool ParticlesSetColorsCallback(RwBool testEnable);
extern RwBool ParticlesSaveCallback(RwBool testEnable);

#ifdef    __cplusplus
}
#endif  /* __cplusplus */

#endif  /* PRTCLS1_H*/


