/****************************************************************************
 *
 * This file is a product of Criterion Software Ltd.
 *
 * This file is provided as is with no warranties of any kind and is
 * provided without any obligation on Criterion Software Ltd.
 * or Canon Inc. to assist in its use or modification.
 *
 * Criterion Software Ltd. and Canon Inc. will not, under any
 * circumstances, be liable for any lost revenue or other damages
 * arising from the use of this file.
 *
 * Copyright (c) 1999 Criterion Software Ltd.
 * All Rights Reserved.
 *
 */

/****************************************************************************
 *                                                                         
 * events.c
 *
 * Copyright (C) 1999 Criterion Technologies.
 *                                                                         
 * Purpose : Handles Sky events.
 *                         
 ****************************************************************************/

#include "rwcore.h"
#include "rt2d.h"

#include "main.h"
#include "paint2d.h"
#include "skeleton.h"
#include "menu.h"


/*
 *****************************************************************************
 */
static RsEventStatus
PadButtonDown(void *param)
{
    RsPadButtonStatus *pbs = (RsPadButtonStatus*)param;

    PositionSet(WinWidth * 0.5f, WinHeight * 0.5f);
    if (pbs->padButtons & rsPADBUTTON5)
    {
        ZoomInToggle(TRUE);
    }
    if (pbs->padButtons & rsPADBUTTON6)
    {
        ZoomOutToggle(TRUE);
    }
    return (rsEVENTNOTPROCESSED);
}

/*
 *****************************************************************************
 */
static RsEventStatus
PadButtonUp(void *param)
{
    RsPadButtonStatus *pbs = (RsPadButtonStatus*)param;

    if (pbs->padButtons & rsPADBUTTON5)
    {
        ZoomInToggle(FALSE);
    }
    if (pbs->padButtons & rsPADBUTTON6)
    {
        ZoomOutToggle(FALSE);
    }
    if (pbs->padButtons & rsPADBUTTON1)
    {
        PageSet(1);
    }
    if (pbs->padButtons & rsPADBUTTON2)
    {
        PageSet(2);
    }
    if (pbs->padButtons & rsPADBUTTON3)
    {
        PageSet(3);
    }

    return (rsEVENTNOTPROCESSED);
}

/*
 *****************************************************************************
 */
RsEventStatus 
PadHandler(RsEvent event, void *param)
{
    if( MenuPadHandler(event, param) == rsEVENTPROCESSED )
    {
        return( rsEVENTPROCESSED );
    }

    switch (event)
    {
        case rsPADBUTTONDOWN:
        {
            return (PadButtonDown(param));
        }

        case rsPADBUTTONUP:
        {
            return (PadButtonUp(param));
        }

        case rsPADANALOGUERIGHT:
        {
            RwV2d   delta;

            RwV2dScale (&delta, (RwV2d *)param, 2.0f);

            PageRotateInit(WinWidth * 0.5f, WinHeight * 0.5f);
            PageRotate(delta.x);

            return (rsEVENTNOTPROCESSED);
        }

        case rsPADANALOGUELEFT:
        {
            RwV2d delta;

            RwV2dScale (&delta, (RwV2d *)param, 4.0f);

            PageTranslateInit();
            PageTranslate(delta.x, delta.y);

            return (rsEVENTNOTPROCESSED);
        }

        default:
            return (rsEVENTNOTPROCESSED);
    }

    return (rsEVENTNOTPROCESSED);
}


/*
 *****************************************************************************
 */
RwBool
AttachInputDevices(void)
{
    /*
     * Register device input handlers here...
     */
    RsInputDeviceAttach(rsPAD, PadHandler);

    return TRUE;
}
/*
 *****************************************************************************
 */