#ifndef _INC_SKYISMS_H
#define _INC_SKYISMS_H

#include "rwcore.h"


/******************************************************/

/* RWPUBLIC */

typedef struct RwMeshCache RwMeshCache;

/**
 * \ingroup rpworldp2sky2
 * \struct RwMeshCache
 * Holds pointers to RwResEntrys for all the meshes in an object.
 */
struct RwMeshCache
{
    RwUInt32    lengthOfMeshesArray; /**< Number of meshes in the object */
    RwResEntry *meshes[1]; /**< The RwMeshCache structure will be 
                            * allocated sufficiently big that this tail 
                            * array can hold lengthOfMeshesArray pointers to 
                            * \ref RwResEntry's */
};

extern RwInt32 rwPip2GeometryOffset;
extern RwInt32 rwPip2AtomicOffset;
extern RwInt32 rwPip2WorldSectorOffset;

/* access to the atomic/worldsector extension data
 * we use for per-mesh cacheing */

#define RWMESHCACHEFROMGEOMETRY(_geometry)                             \
    ( *(RwMeshCache * *)                                               \
      (((RwUInt8 *) (_geometry)) +  rwPip2GeometryOffset) )

#define RWMESHCACHEFROMCONSTGEOMETRY(_geometry)                        \
    ( *(const RwMeshCache * *)                                         \
      (((const RwUInt8 *) (_geometry)) +  rwPip2GeometryOffset) )

#define RWMESHCACHEFROMATOMIC(_atomic)                                 \
    ( *(RwMeshCache * *)                                               \
      (((RwUInt8 *) (_atomic)) + rwPip2AtomicOffset) ) 

#define RWMESHCACHEFROMCONSTATOMIC(_atomic)                            \
    ( *(const RwMeshCache * *)                                         \
      (((const RwUInt8 *) (_atomic)) + rwPip2AtomicOffset) )

#define RWMESHCACHEFROMWORLDSECTOR(_worldSector)                       \
    ( *(RwMeshCache * *)                                               \
      (((RwUInt8 *) (_worldSector)) + rwPip2WorldSectorOffset) )

#define RWMESHCACHEFROMCONSTWORLDSECTOR(_worldSector)                  \
    ( *(const RwMeshCache * *)                                         \
      (((const RwUInt8 *) (_worldSector)) +  rwPip2WorldSectorOffset) )


/* These are used in matInstance. These are the properties
 * which, if changed, should cause a full reinstance. */
#define WORLDRENDERTYPEMASK (rpWORLDTRISTRIP | \
                             rpWORLDTEXTURED | \
                             rpWORLDPRELIT   | \
                             rpWORLDNORMALS  | \
                             rpWORLDTEXTURED2)
/* Notice that rpWORLDLIGHT and rpWORLDMODULATEMATERIALCOLOR don't cause a
 * reinstance (former is tested in objAllInOne lighting code and latter in
 * the matBridge material setup code) */
#define ATOMICRENDERTYPEMASK (rpGEOMETRYTRISTRIP  | \
                              rpGEOMETRYPOSITIONS | \
                              rpGEOMETRYTEXTURED  | \
                              rpGEOMETRYPRELIT    | \
                              rpGEOMETRYNORMALS   | \
                              rpGEOMETRYTEXTURED2)
/* rpGEOMETRYPOSITIONS included for completeness... why not? */

/* RWPUBLICEND */

#endif /* _INC_SKYISMS_H */
