/****************************************************************************
 *                                                                          *
 * module : nodePS2WorldSectorDispatch.c                                    *
 *                                                                          *
 * purpose: yawn...                                                         *
 *                                                                          *
 ****************************************************************************/

/****************************************************************************
 includes
 */

#include <math.h>
#include <eekernel.h> /* SyncDCache(), etc. */
#include "rwcore.h"
#include "baworld.h"
#include "p2stdclsw.h"
#include "skyisms.h"
#include "nodePS2WorldSectorDispatch.h"

/****************************************************************************
 local types
 */

/****************************************************************************
 local (static) prototypes
 */

static RwBool
_rwPS2WorldSectorDispatchNodeBody(RwPipelineNodeInstance *self,
                                  RwMemoryArena *arena __RWUNUSED__,
                                  void *data);

/****************************************************************************
 local defines
 */

/****************************************************************************
 local (static) globals
 */

/*****************************************************/
/**                                                 **/
/**  PS2WORLDSECTORDISPATCH.CSL NODE SPECIFICATION  **/
/**                                                 **/
/*****************************************************/

#define NUMCLUSTERSOFINTEREST 1
#define NUMOUTPUTS            0

static RwClusterRef gNodeClusters[NUMCLUSTERSOFINTEREST] =
{
      /* 0 */
    { &clusterPS2DMAChain }
};

/* input requirements (this array parallel to ClusterRefs) */
static RwClusterValidityReq gNodeReqs[NUMCLUSTERSOFINTEREST] =
{
    { rwCLREQREQUIRED     }
};

RwNodeDefinition nodePS2WorldSectorDispatchCSL =
{
    "PS2WorldSectorDispatch.csl",          // Name
    {                                      // nodemethods
        _rwPS2WorldSectorDispatchNodeBody, // +-- nodebody
    },
    {                                      // Io
        NUMCLUSTERSOFINTEREST,             // +-- NumClustersOfInterest
        gNodeClusters,                     // +-- ClustersOfInterest
        gNodeReqs,                         // +-- InputRequirements
        NUMOUTPUTS,                        // +-- NumOutputs
        NULL                               // +-- Outputs
    }
};

/*****************************************************/

/****************************************************************************
 functions
 */

/****************************************************************************
 _rwPS2WorldSectorDispatchNodeBody()
 */

static RwBool
_rwPS2WorldSectorDispatchNodeBody(RwPipelineNodeInstance *self,
                                  RwMemoryArena *arena __RWUNUSED__,
                                  void *data)
{
}
