/***************************************************************************
 *                                                                         *
 * Module  : fastim3d.h                                                    *
 *                                                                         *
 * Purpose : See fastim3d.c                                                *
 *                                                                         *
 **************************************************************************/

#ifndef FASTIM3D_H
#define FASTIM3D_H

/****************************************************************************
 Includes
 */

#include <rwcore.h>

/****************************************************************************
 Function prototypes
 */

/* RWPUBLIC */

#ifdef    __cplusplus
extern "C"
{
#endif /* __cplusplus */

extern RxPipeline * RwIm3DSkyGetPS2ManagerRenderPipeline(RwPrimitiveType type);
extern RxPipeline * RwIm3DSkyGetPS2ManagerTransformPipeline(void);

extern RxPipeline * RwIm3DSkyGetPS2AllRenderPipeline(RwPrimitiveType type);
extern RxPipeline * RwIm3DSkyGetPS2AllMatPipeline(RwPrimitiveType type);

/* RWPUBLICEND */

extern RwBool _rwfastIm3DPipesOpen(void);
extern void   _rwfastIm3DPipesClose(void);

#define _fastIm3DPipesOpen()  _rwfastIm3DPipesOpen()
#define _fastIm3DPipesClose() _rwfastIm3DPipesClose()

/* RWPUBLIC */

#ifdef    __cplusplus
}
#endif /* __cplusplus */

/* RWPUBLICEND */

#endif /* FASTIM3D_H */
