/*
 * Data structures for core functionailty of custom pipelines
 * Copyright (c) Criterion Software Limited
 */

/****************************************************************************
 *                                                                          *
 * module : p2stdclsw.h                                                     *
 *                                                                          *
 * purpose: declare standard world pipeline clusters and associated types   *
 *                                                                          *
 ****************************************************************************/

#ifndef P2STDCLSW_H
#define P2STDCLSW_H

/****************************************************************************
 includes
 */

#include "rwcore.h"
#include "balight.h"
#include "baworld.h"
#include "baclump.h"

/****************************************************************************
 global types
 */

/* see Lights.csl below */
/* RWPUBLIC */

#if (!defined(RXPIPELINE))
#define RXPIPELINE
#endif /* (!defined(RXPIPELINE)) */
typedef RpLight *RxLight;
/* RWPUBLICEND */

/****************************************************************************
 global prototypes
 */

/* RWPUBLIC */
#ifdef    __cplusplus
extern "C"
{
#endif                          /* __cplusplus */

extern RxClusterDefinition RxClLights; /* Uses the RxLight type (see above) */

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

/* RWPUBLICEND */

/* TODO: p2stdclsw.[c|h] for each driver, to eliminate platform-specific clusters */

/* RWPUBLIC */

#if (((defined(SKY) || defined(SKY_OSTYPES_H)) && !defined(NULLSKY_DRVMODEL_H)))

/* RWPUBLICEND
 * Don't change these
 * RWPUBLIC */

/**
 * \ingroup rpworldp2sky2
 * \ref RxPS2ObjectType
 * Values identifying different PS2-specific object types.
 */
enum RxPS2ObjectType
{
    rxOBJTYPE_WORLDSECTOR = 0, /**< The object is an \ref RpWorldSector */
    rxOBJTYPE_ATOMIC      = 1, /**< The object is an \ref RpAtomic */
    /* RWPUBLICEND
     * Temporary until PS2MANAGER rendering gets moved into the core
     * RWPUBLIC */
    rxOBJTYPE_IM3D        = 2, /**< The object is an rwIm3DPoolStash */
    rxOBJTYPEFORCEENUMSIZEINT = RWFORCEENUMSIZEINT
};
typedef enum RxPS2ObjectType RxPS2ObjectType;

typedef union RxObjUnion RxObjUnion;
/**
 * \ingroup rpworldp2sky2
 * \union RxObjUnion
 * A union used by the \ref RxPS2DMASessionRecord structure
 */
union RxObjUnion
{
    RpWorldSector *worldSector; /**< \ref RpWorldSector pointer union member */
    RpAtomic *atomic;           /**< \ref RpAtomic pointer union member */
    void *agnostic;             /**< void pointer union member */
};


typedef struct RxPS2DMASessionRecord RxPS2DMASessionRecord;
/**
 * \ingroup rpworldp2sky2
 * \struct RxPS2DMASessionRecord
 * Describes information for an object's DMA packet(s)
 */
struct RxPS2DMASessionRecord
{
    RxPS2ObjectType objType;       /**< \ref RxPS2ObjectType type identifier */
    RxObjUnion sourceObject;       /**< \ref RxObjUnion referencing the source object */
    RwFrustumTestResult inFrustum; /**< \ref RwFrustumTestResult frustum test result */
    RwUInt16 serialNum;            /**< \ref RwUInt16 serial number used when
                                    *   choosing whether to re-instance object data */
    RwUInt8 vu1CodeIndex;             /**< \ref RwUInt8 index into VU code array,
                                    *   specifying the transform to use. */
    RwUInt8 primType;              /**< \ref RwUInt8 code for the primitive type that will
                                    *   be submitted by VU1 to the GS (see GS manual ~p113). */
    RxSkyTransTypeFlags transType; /**< \ref RxSkyTransTypeFlags flags, specifying the type
                                    *   of transform to use (ortho/persp, fog/not, etc). */
};


typedef struct RxPS2Mesh RxPS2Mesh;
/**
 * \ingroup rpworldp2sky2
 * \struct RxPS2Mesh
 * Describes PS2-specific information for a mesh
 */
struct RxPS2Mesh
{
    const RpMesh *mesh;          /**< A pointer to the source \ref RpMesh */
    RwResEntry  **cacheEntryRef; /**< A pointer to a pointer to a \ref RwResEntry
                                  *   holding the instance data for the mesh */
    RwUInt32      meshNum;       /**< The number of the current mesh within
                                  *   its parent object (from zero) */
    RwUInt32      pad;           /**< Alignment padding to 16 bytes/1 QW */
};

#ifdef    __cplusplus
extern "C"
{
#endif                          /* __cplusplus */

extern RxClusterDefinition RxClPS2DMAChain ;
extern RxClusterDefinition RxClPS2LightsBlock ;
extern RxClusterDefinition RxClPS2DMASessionRecord ;
extern RxClusterDefinition RxClPS2Mesh ;
extern RxClusterDefinition RxClPS2xyz ;
extern RxClusterDefinition RxClPS2uv;
extern RxClusterDefinition RxClPS2uv2;
extern RxClusterDefinition RxClPS2rgba;
extern RxClusterDefinition RxClPS2normal;

extern RxClusterDefinition RxClPS2user1;
extern RxClusterDefinition RxClPS2user2;
extern RxClusterDefinition RxClPS2user3;
extern RxClusterDefinition RxClPS2user4;

extern RwChar              RxPS2AttributeSet[];

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

#endif /* (((defined(SKY) || defined(SKY_OSTYPES_H)) && !defined(NULLSKY_DRVMODEL_H))) */

/* RWPUBLICEND */

#endif /* P2STDCLSW_H */
