
/****************************************************************************
 *                                                                          *
 * module : p2stdclsw.c                                                     *
 *                                                                          *
 * purpose: Initialise the values of the global world cluster definitions   *
 *                                                                          *
 ****************************************************************************/

/****************************************************************************
 includes
 */

#include <rwcore.h>

/*
 * NOTE THAT THE *TWO* OCCURRANCES OF 'SKY' PREDICATION IS TEMPORARY WHILE
 * SOMEONE FIGURES OUT HOW TO REMOVE PLATFORM-SPECIFICS FROM THIS
 * PLATFORM-INDEPENDENT SOURCE FILE. BUILDS ON OTHER PLATFORMS JUST DOESN'T
 * WORK WITHOUT THIS PREDICATION.
 * (JohnI 2000/03/06)
 */

#if (((defined(SKY) || defined(SKY2_DRVMODEL_H)) && !defined(NULLSKY_DRVMODEL_H)))
#include "ps2clusterattribs.h"
#endif /* (((defined(SKY) || defined(SKY2_DRVMODEL_H)) && !defined(NULLSKY_DRVMODEL_H))) */

#include "p2stdclsw.h"

#if (!defined(DOXYGEN))
static const char rcsid[] __RWUNUSED__ = "@@(#)$Id: p2stdclsw.c,v 1.26 2001/07/11 11:48:14 iestynb Exp $";
#endif /* (!defined(DOXYGEN)) */


/****************************************************************************
 Globals (across program)
 */

#define _DEFAULTSTRIDE     ((RwUInt32)0)
#define _DEFAULTATTRIBUTES ((RwUInt32)0)
#define _ATTRIBUTESET      ((const char *)NULL)

static RwChar _Lights_csl[] = RWSTRING("Lights.csl");

RxClusterDefinition RxClLights =
{ /* Uses the RxLight type */
    _Lights_csl,
    _DEFAULTSTRIDE,
    _DEFAULTATTRIBUTES,
    _ATTRIBUTESET
};

#if (((defined(SKY) || defined(SKY2_DRVMODEL_H)) && !defined(NULLSKY_DRVMODEL_H)))

/* open architecture stuff / SDM 00-02-22 */
#define _PS2ATTRIBUTESET RxPS2AttributeSet

static RwChar _PS2DMAChain_csl[] = RWSTRING("PS2DMAChain.csl");
static RwChar _PS2LightsBlock_csl[] = RWSTRING("PS2LightsBlock.csl");
RwChar RxPS2AttributeSet[] = RWSTRING("PS2");
static RwChar _PS2DMASessionRecord_csl[] = RWSTRING("PS2DMASessionRecord.csl");
static RwChar _PS2Mesh_csl[] = RWSTRING("PS2Mesh.csl");
static RwChar _PS2xyz_csl[] = RWSTRING("PS2xyz.csl");
static RwChar _PS2uv_csl[] = RWSTRING("PS2uv.csl");
static RwChar _PS2uv2_csl[] = RWSTRING("PS2uv2.csl");
static RwChar _PS2rgba_csl[] = RWSTRING("PS2rgba.csl");
static RwChar _PS2normal_csl[] = RWSTRING("PS2normal.csl");
static RwChar _PS2user1_csl[] = RWSTRING("PS2user1.csl");
static RwChar _PS2user2_csl[] = RWSTRING("PS2user2.csl");
static RwChar _PS2user3_csl[] = RWSTRING("PS2user3.csl");
static RwChar _PS2user4_csl[] = RWSTRING("PS2user4.csl");

RxClusterDefinition RxClPS2DMAChain =
{
    _PS2DMAChain_csl,
    _DEFAULTSTRIDE,
    _DEFAULTATTRIBUTES,
    _ATTRIBUTESET
};

RxClusterDefinition RxClPS2LightsBlock =
{
    _PS2LightsBlock_csl,
    _DEFAULTSTRIDE,
    _DEFAULTATTRIBUTES,
    _ATTRIBUTESET
};

RxClusterDefinition RxClPS2DMASessionRecord =
{
    _PS2DMASessionRecord_csl,
    _DEFAULTSTRIDE,
    _DEFAULTATTRIBUTES,
    _PS2ATTRIBUTESET
};

RxClusterDefinition RxClPS2Mesh =
{
    _PS2Mesh_csl,
    _DEFAULTSTRIDE,
    _DEFAULTATTRIBUTES,
    _PS2ATTRIBUTESET
};

RxClusterDefinition RxClPS2xyz =
{
    _PS2xyz_csl,
    _DEFAULTSTRIDE,
        CL_ATTRIB_REQUIRED |
     /* CL_ATTRIB_READ | 
      * CL_ATTRIB_WRITE | 
      * CL_ATTRIB_DONT_FILL | 
      * CL_ATTRIB_PLACEHOLDER | */
        CL_ATTRIB_OPAQUE |
     /* CL_ATTRIB_STATIC | 
      * CL_S32 | 
      * CL_V2_32 | 
      * CL_V2_16 | */
        CL_V3_32 |
     /* CL_V4_32 | 
      * CL_V4_16 | 
      * CL_V4_8  | 
      * CL_USN   | */
        0,
    _PS2ATTRIBUTESET
};

RxClusterDefinition RxClPS2uv =
{
    _PS2uv_csl,
    _DEFAULTSTRIDE,
        CL_ATTRIB_REQUIRED |
     /* CL_ATTRIB_READ | 
      * CL_ATTRIB_WRITE | 
      * CL_ATTRIB_DONT_FILL | 
      * CL_ATTRIB_PLACEHOLDER | */
        CL_ATTRIB_OPAQUE |
     /* CL_ATTRIB_STATIC | 
      * CL_S32 | */
        CL_V2_32 |
     /* CL_V2_16 | 
      * CL_V3_32 | 
      * CL_V4_32 | 
      * CL_V4_16 | 
      * CL_V4_8  | 
      * CL_USN   | */
        0,
    _PS2ATTRIBUTESET
};

RxClusterDefinition RxClPS2uv2 =
{
    _PS2uv2_csl,
    _DEFAULTSTRIDE,
        CL_ATTRIB_REQUIRED |
     /* CL_ATTRIB_READ | 
      * CL_ATTRIB_WRITE | 
      * CL_ATTRIB_DONT_FILL | 
      * CL_ATTRIB_PLACEHOLDER | */
        CL_ATTRIB_OPAQUE |
     /* CL_ATTRIB_STATIC | 
      * CL_S32 |
      * CL_V2_32 |
      * CL_V2_16 | 
      * CL_V3_32 | */
        CL_V4_32 |
     /* CL_V4_16 | 
      * CL_V4_8  | 
      * CL_USN   | */
        0,
    _PS2ATTRIBUTESET
};

RxClusterDefinition RxClPS2rgba =
{
    _PS2rgba_csl,
    _DEFAULTSTRIDE,
        CL_ATTRIB_REQUIRED |
     /* CL_ATTRIB_READ | 
      * CL_ATTRIB_WRITE | 
      * CL_ATTRIB_DONT_FILL | 
      * CL_ATTRIB_PLACEHOLDER | */
        CL_ATTRIB_OPAQUE |
     /* CL_ATTRIB_STATIC | 
      * CL_S32 | 
      * CL_V2_32 | 
      * CL_V2_16 | 
      * CL_V3_32 | 
      * CL_V4_32 | 
      * CL_V4_16 | */
        CL_V4_8  |
        CL_USN   |
        0,
    _PS2ATTRIBUTESET
};

RxClusterDefinition RxClPS2normal =
{
    _PS2normal_csl,
    _DEFAULTSTRIDE,
        CL_ATTRIB_REQUIRED |
     /* CL_ATTRIB_READ | 
      * CL_ATTRIB_WRITE | 
      * CL_ATTRIB_DONT_FILL | 
      * CL_ATTRIB_PLACEHOLDER | */
        CL_ATTRIB_OPAQUE |
     /* CL_ATTRIB_STATIC | 
      * CL_S32 | 
      * CL_V2_32 | 
      * CL_V2_16 | 
      * CL_V3_32 | 
      * CL_V4_32 | 
      * CL_V4_16 | */
        CL_V4_8  |
     /* CL_USN   | */
        0,
    _PS2ATTRIBUTESET
};

RxClusterDefinition RxClPS2user1 =
{
    _PS2user1_csl,
    _DEFAULTSTRIDE,
        CL_ATTRIB_REQUIRED |
/* This should be visible from nodes in the pipe since
   it needs to be filled by *someone*! */
        CL_ATTRIB_READ | 
        CL_ATTRIB_WRITE | 
     /* CL_ATTRIB_DONT_FILL | 
      * CL_ATTRIB_PLACEHOLDER | 
      * CL_ATTRIB_OPAQUE | 
      * CL_ATTRIB_STATIC | 
      * CL_S32 | 
      * CL_V2_32 | 
      * CL_V2_16 | 
      * CL_V3_32 | */
        CL_V4_32 |
     /* CL_V4_16 | 
      * CL_V4_8  | 
      * CL_USN   | */
        0,
    _PS2ATTRIBUTESET
};

RxClusterDefinition RxClPS2user2 =
{
    _PS2user2_csl,
    _DEFAULTSTRIDE,
        CL_ATTRIB_REQUIRED |
/* This should be visible from nodes in the pipe since
   it needs to be filled by *someone*! */
        CL_ATTRIB_READ | 
        CL_ATTRIB_WRITE | 
     /* CL_ATTRIB_DONT_FILL | 
      * CL_ATTRIB_PLACEHOLDER | 
      * CL_ATTRIB_OPAQUE | 
      * CL_ATTRIB_STATIC | 
      * CL_S32 | 
      * CL_V2_32 | 
      * CL_V2_16 | 
      * CL_V3_32 | */
        CL_V4_32 |
     /* CL_V4_16 | 
      * CL_V4_8  | 
      * CL_USN   | */
        0,
    _PS2ATTRIBUTESET
};

RxClusterDefinition RxClPS2user3 =
{
    _PS2user3_csl,
    _DEFAULTSTRIDE,
        CL_ATTRIB_REQUIRED |
/* This should be visible from nodes in the pipe since
   it needs to be filled by *someone*! */
        CL_ATTRIB_READ | 
        CL_ATTRIB_WRITE | 
     /* CL_ATTRIB_DONT_FILL | 
      * CL_ATTRIB_PLACEHOLDER | 
      * CL_ATTRIB_OPAQUE | 
      * CL_ATTRIB_STATIC | 
      * CL_S32 | 
      * CL_V2_32 | 
      * CL_V2_16 | 
      * CL_V3_32 | */
        CL_V4_32 |
     /* CL_V4_16 | 
      * CL_V4_8  | 
      * CL_USN   | */
        0,
    _PS2ATTRIBUTESET
};

RxClusterDefinition RxClPS2user4 =
{
    _PS2user4_csl,
    _DEFAULTSTRIDE,
        CL_ATTRIB_REQUIRED |
/* This should be visible from nodes in the pipe since
   it needs to be filled by *someone*! */
        CL_ATTRIB_READ | 
        CL_ATTRIB_WRITE | 
     /* CL_ATTRIB_DONT_FILL | 
      * CL_ATTRIB_PLACEHOLDER | 
      * CL_ATTRIB_OPAQUE | 
      * CL_ATTRIB_STATIC | 
      * CL_S32 | 
      * CL_V2_32 | 
      * CL_V2_16 | 
      * CL_V3_32 | */
        CL_V4_32 |
     /* CL_V4_16 | 
      * CL_V4_8  | 
      * CL_USN   | */
        0,
    _PS2ATTRIBUTESET
};
#endif /* (((defined(SKY) || defined(SKY2_DRVMODEL_H)) && !defined(NULLSKY_DRVMODEL_H))) */

