/****************************************************************************
 *                                                                          *
 * module : nodeCullTriangleByTriPlane.h                                    *
 *                                                                          *
 * purpose: see nodeCullTriangleByTriPlane.c (and below)                    *
 *                                                                          *
 ****************************************************************************/

/* This culls all backfaced triangles and uses the old vertex tag table method to
   work out which vertices are left unused. It then creates a 'VSteps' cluster,
   which tells subsequent nodes how to skip over unused verts (for each used
   vertex, the VSteps entry is the number of increments to get to the next
   used vertex). nodes are free to ignore VSteps but they may be more inefficient
   if they do so (balance VSteps memory access and skipping-increment logic
   against core per-vertex calculations).

   This version can be placed at the top of the pipeline since it doesn't use
   vertex data to do the culling, it uses TriPlanes. It can probably be placed
   further down the pipe too (but why?), as long as the triplanes cluster is
   still valid (so not after clipping or refinement, say, where new tris will
   have been created)
 */

#ifndef NODECULLTRIANGLEBYTRIPLANE_H
#define NODECULLTRIANGLEBYTRIPLANE_H

#include <rwcore.h>

/****************************************************************************
 global prototypes
 */

/* RWPUBLIC */

#if (!defined(RXPIPELINE))
#define RXPIPELINE
#endif /* (!defined(RXPIPELINE)) */

#ifdef    __cplusplus
extern "C"
{
#endif                          /* __cplusplus */

extern RxNodeDefinition *RxNodeDefinitionGetCullTriangleByTriPlane(void);

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

/* RWPUBLICEND */

#endif /* NODECULLTRIANGLEBYTRIPLANE_H */
