/***************************************************************************
 *                                                                         *
 * Module  : litepipe.h                                                    *
 *                                                                         *
 * Purpose : Lighting pipeline elements                                    *
 *                                                                         *
 **************************************************************************/

#ifndef LITEPIPE_H
#define LITEPIPE_H

/****************************************************************************
 Includes
 */

#include <rwcore.h>
#include "balight.h"

/****************************************************************************
 Defines
 */

/****************************************************************************
 Global Types
 */

/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern "C"
{
#endif                          /* __cplusplus */

/* Pipeline functionality for the lights */
extern void _rpPipeApplyLight(RwResEntry *repEntry, const void *voidLight,
                              const RwMatrix *inverseMat, RwReal invScale,
                              const RwSurfaceProperties *surfaceProps);
extern void _rpPipePreLight(RwResEntry *repEntry);
extern void _rpPipePostLight(RwResEntry *repEntry);
extern void initGenericLightApply(RpLight *light);

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

#endif /* LITEPIPE_H */
