#include <stdlib.h>

#include <rwcore.h>
#include "baworld.h"
#include "bapipif.h"

#include "bapipew.h"

static const char _rcsid[] __RWUNUSED__ = "@@(#)$Id: bapiwcom.c,v 1.8 2000/10/17 12:44:20 johns Exp $";


/****************************************************************************
 _rpWorldPipeAttach

 On entry   : (void)
 On exit    : TRUE on success
 */
RwBool
_rpWorldPipeAttach(void)
{
    RWFUNCTION(RWSTRING("_rpWorldPipeAttach"));

    RWRETURN(rpGetWorldPipeInterface()->pipeAttach());
}

/****************************************************************************
 _rpPipeSetupAtomPipe

 On entry   : Pipeline
 On exit    : TRUE on success
 */
RwBool
_rpPipeSetupAtomPipe(RwRenderPipeline *pipe)
{
    RWFUNCTION(RWSTRING("_rpPipeSetupAtomPipe"));

    RWRETURN(rpGetWorldPipeInterface()->pipeSetupAtomPipe(pipe));
}

/****************************************************************************
 _rpPipeSetupSectPipe

 On entry   : Pipeline
 On exit    : TRUE on success
 */
RwBool
_rpPipeSetupSectPipe(RwRenderPipeline *pipe)
{
    RWFUNCTION(RWSTRING("_rpPipeSetupSectPipe"));

    RWRETURN(rpGetWorldPipeInterface()->pipeSetupSectPipe(pipe));
}

/****************************************************************************
 _rpPipeSetupLightApply

 On entry   : Light
 On exit    : None
 */
void
_rpPipeSetupLightApply(RpLight *light)
{
    RWFUNCTION(RWSTRING("_rpPipeSetupLightApply"));

    rpGetWorldPipeInterface()->pipeSetupLightApply(light);

    RWRETURNVOID();
}
