
/***************************************************************************
 *                                                                         *
 * Module  : gstate.h                                                      *
 *                                                                         *
 * Purpose :                                                            *
 *                                                                         *
 **************************************************************************/

#ifndef GSTATE_H
#define GSTATE_H

/****************************************************************************
 Includes

*/
#include <rwcore.h>

#include "path.h"
#include "font.h"

#include "ps2font.h"
#include "ps2sgfnt.h"

/****************************************************************************
 Defines
 */
/* see section 4.3 of the EE User's Manual (2nd ed.) for these */
#define VIFCMD_UNPACK (0x6cl << 24)
#define VIFCMD_CYCLE (0x01l << 24)
#define VIFCMD_DIRECT (0x50l << 24)
#define VIFCMD_NOP (0x00l << 24)

#define MAXVINDEX (256/4 * 6)

#define RT2DPS2MAXVERT      64

#define RT2DPS2STRCACHEMAX  16

#define RT2DSTRBUFFER    1024

#define RT2DPS2COLSCALE     ((RwReal) 128.1 / (RwReal) 255.0)

/****************************************************************************
 Global Types
 */
#ifdef SKY2_DRVMODEL_H


typedef union _Rt2dUnion128 Rt2dUnion128;

union _Rt2dUnion128
{
    RwReal      float32[4];
    RwInt32     int32[4];
    u_long128   int128;
};

#endif /* SKY2_MODEL_H */


typedef struct Rt2dStrBuffer Rt2dStrBuffer;

struct Rt2dStrBuffer
{
    RwInt32             space;
    Rt2dFontChar       *str;
    Rt2dFontChar        buffer[RT2DSTRBUFFER];
};

/* String cache for string. */
typedef struct Rt2dPS2StrCache RWALIGN(Rt2dPS2StrCache, rwMATRIXALIGNMENT);

typedef struct Rt2dGlobalVars Rt2dGlobalVars;
struct Rt2dGlobalVars
{
    RwImVertexIndex     topo[256];
    RwImVertexIndex     fonttopo[MAXVINDEX];

    RwFreeList         *brushFreeList;

    RwFreeList         *fontFreeList;
    RwChar              fontPath[128];

    RwFreeList         *pathFreeList;
    Rt2dPath           *scratch;

    RwMatrix           *ctm[32];
    RwInt32             mtos;

    RwV2d               vw;
    RwV2d               vp;

    RwMatrix            CTM2d, iCTM2d;
    RwMatrix            CTM;
    RwBool              CTMValid;
    RwUInt32            TransformFlags;

    RwReal              layerDepth;
    RwReal              tolerance;
    RwReal              sqTolerance;
    RwBool              sqToleranceValid;

    RwInt32             extensionOffset;

    RwReal              deviceX;
    RwReal              deviceY;
    RwReal              deviceW;
    RwReal              deviceH;

    RwCamera           *viewCamera;

    /* Pipeline Stuff. */

    Rt2dBrush          *brush;
    Rt2dFont           *font;
    Rt2dPath           *path;
    Rt2dFontChar       *str;

    rt2dPathNode       *pnode0;
    rt2dPathNode       *pnode1;

    RwReal              pathInset;
    RwReal              oobaseu;
    RwReal              fontbaseu;

    Rt2dBBox            bbox;
    RwV2d               delta;

    RwInt32             numVerts;

    RwCameraBeginUpdateFunc cameraBeginUpdate;
    RwCameraEndUpdateFunc cameraEndUpdate;

#ifdef RXPIPELINE

    RxClusterDefinition RxClPS2FillPos;
    RxClusterDefinition RxClPS2FillNrm;

    RxClusterDefinition RxClPS2FontUV1;
    RxClusterDefinition RxClPS2FontUV2;

    RxClusterDefinition RxClPS2StrokePos;
    RxClusterDefinition RxClPS2StrokeNrm;

    RxClusterDefinition RxClPS2SingleFont;

    RxPipeline         *default_pipe, *use_pipe;

    RxPipeline         *default_stroke_pipe, *use_stroke_pipe;
    RxPipeline         *default_font_pipe, *use_font_pipe;
    RxPipeline         *default_fill_pipe, *use_fill_pipe;
    RxPipeline         *default_sgfont_pipe, *use_sgfont_pipe;

    RwInt32             fill_batch_sz, font_batch_sz, stroke_batch_sz,
        sgfont_batch_sz;

    Rt2dStrBuffer       strBuffer;

    Rt2dPS2StrCache     strCacheBuffer[RT2DPS2STRCACHEMAX];

    Rt2dFont           *fontBatch;
    Rt2dPS2StrCache    *strCache;

    Rt2dPS2StrCache    *freeStrCache;

#endif                          /* RXPIPELINE */

};

typedef struct Rt2dInstanceData Rt2dInstanceData;
struct Rt2dInstanceData
{
    RwMatrix           *matrix;
    RWIM3DVERTEX       *vertexData;
    RWIMVERTEXINDEX    *indexData;
    RwUInt32            vertexCount;
    RwUInt32            indexCount;
    RwUInt32            vertexStride;
    RwUInt32            indexStride;

    RwPrimitiveType     primType;
    RwUInt32            flag;
};

typedef struct Rt2dInstanceObject Rt2dInstanceObject;
struct Rt2dInstanceObject
{
    Rt2dBrush          *brush;
    Rt2dPath           *path;
    Rt2dFont           *font;
    RwChar             *string;
    RwMatrix           *ctm;
    RwPrimitiveType     primType;
    RwUInt32            flag;
};

extern Rt2dGlobalVars Rt2dGlobals;

 /****************************************************************************
 Function prototypes
 */

extern RwMatrix    *_rt2dCTMGetInverse(void);
extern RwBool       _rt2dCTMGetWinding(void);
extern RwReal       _rt2dGetTolerance(void);

/* init */
extern RwBool       _rt2dGstateOpen(void);
extern void         _rt2dGstateClose(void);

#endif /* GSTATE_H */
