/*
 * Immediate mode rendering (platform-specific)
 * 
 * Copyright (c) Criterion Software Limited
 */

/* The documentation in here is platform-specific versions of function-
 * descriptions for functions in baim3d.c 
 */

/***************************************************************************
 *                                                                         *
 * Module  : im3dpipe.c                                                    *
 *                                                                         *
 * Purpose : Platform specific pipeline construction                       *
 *                                                                         *
 **************************************************************************/

/****************************************************************************
 Includes
 */

#include "batypes.h"

#include "bapipe.h"
#include "p2core.h"
#include "p2define.h"
#include "p2stdcls.h"

#include "nodeImmInstance.h"
#include "nodeTransform.h"
#include "nodeImmRenderSetup.h"
/* #include "nodeScatter.h" */
#include "nodeImmStash.h"
#include "nodeImmMangleLineIndices.h"
#include "nodeImmMangleTriangleIndices.h"
#include "nodeCullTriangle.h"
#include "nodeClipLine.h"
#include "nodeClipTriangle.h"
#include "nodeSubmitLine.h"
#include "nodeSubmitTriangle.h"

#include "im3dpipe.h"

static const char rcsid[] __RWUNUSED__ = 
    "@@(#)$Id: im3dpipe.c,v 1.38 2001/02/07 19:25:49 katherinet Exp $";

/**
 * \ingroup rwim3dps2
 * \page RwIm3DGetTransformPipelineplatform RwIm3DGetTransformPipeline (platform-specific)
 *
 * This function returns a pointer to the current Im3D transform pipeline.
 * The default Im3D transform pipeline for PS2 is based on PS2Manager.csl
 * (see \ref RwIm3DSkyGetPS2ManagerTransformPipeline for details).
 *
 * \return A pointer to the current Im3D transform Pipeline on success,
 * otherwise NULL
 *
 * \see RwIm3DSkyGetPS2ManagerTransformPipeline
 * \see RwIm3DGetGenericTransformPipeline
 * \see RwIm3DEnd
 * \see RwIm3DRenderIndexedPrimitive
 * \see RwIm3DRenderLine
 * \see RwIm3DRenderPrimitive
 * \see RwIm3DRenderTriangle
 * \see RwIm3DTransform
 * \see RwIm3DGetRenderPipeline
 * \see \ref RwIm3DGetRenderPipelineplatform
 * \see RwIm3DGetTransformPipeline
 * \see RwIm3DSetRenderPipeline
 * \see RwIm3DSetTransformPipeline
 */
void
rwIm3DDestroyPlatformTransformPipeline(RxPipeline ** __RWUNUSEDRELEASE__ globalPipe)
{
    RWFUNCTION(RWSTRING("rwIm3DDestroyPlatformTransformPipeline"));

    RWASSERT(globalPipe != NULL);

    RWRETURNVOID();
}

RwBool
rwIm3DCreatePlatformTransformPipeline(RxPipeline ** __RWUNUSEDRELEASE__ globalPipe )
{
    RWFUNCTION(RWSTRING("rwIm3DCreatePlatformTransformPipeline"));

    /* The transform pipe for SKY2 (before fastim3d.c intervenes)
     * is the same as the generic pipe. Sweeeet. */

    RWASSERT(globalPipe != NULL);

    RWRETURN(TRUE);
}

/**
 * \ingroup rwim3dps2
 * \page RwIm3DGetRenderPipelineplatform RwIm3DGetRenderPipeline (platform-specific)
 *
 * This function returns a pointer to the current Im3D render pipeline
 * for a specified primitive type. The default Im3D render pipelines for
 * PS2 are based on PS2Manager.csl (see
 * \ref RwIm3DSkyGetPS2ManagerRenderPipeline for details)
 * and in fact the same pipeline is used to render all primitive types.
 *
 * \return A pointer to the current Im3D transform Pipeline on success,
 * otherwise NULL
 *
 * \see RwIm3DSkyGetPS2ManagerRenderPipeline
 * \see RwIm3DGetGenericRenderPipeline
 * \see RwIm3DEnd
 * \see RwIm3DRenderIndexedPrimitive
 * \see RwIm3DRenderLine
 * \see RwIm3DRenderPrimitive
 * \see RwIm3DRenderTriangle
 * \see RwIm3DTransform
 * \see RwIm3DGetRenderPipeline
 * \see RwIm3DGetTransformPipeline
 * \see \ref RwIm3DGetTransformPipelineplatform
 * \see RwIm3DSetRenderPipeline
 * \see RwIm3DSetTransformPipeline
 */
void
rwIm3DDestroyPlatformRenderPipelines(rwIm3DRenderPipelines * __RWUNUSEDRELEASE__ globalPipes)
{
    RWFUNCTION(RWSTRING("rwIm3DDestroyPlatformRenderPipelines"));

    RWASSERT(globalPipes != NULL);

    RWRETURNVOID();
}

RwBool
rwIm3DCreatePlatformRenderPipelines(rwIm3DRenderPipelines * __RWUNUSEDRELEASE__ globalPipes)
{
    RWFUNCTION(RWSTRING("rwIm3DCreatePlatformRenderPipelines"));

    RWASSERT(globalPipes != NULL);

    /* The tri/line render pipes for SKY2 (before fastim3d.c
     * steps in) are the same as the generic pipes. Rock on. */

    RWRETURN(TRUE);
}

