/**************************************************************************
 * Module  : babbox.h                                                      *
 *                                                                         *
 * Purpose : World handling functions.                                     *
 *                                                                         *
 **************************************************************************/

#ifndef RWBBOX_H
#define RWBBOX_H

/****************************************************************************
 Includes
 */

#include "batype.h"
#include "balibtyp.h"

/****************************************************************************
 Defines
 */

/* RWPUBLIC */
/****************************************************************************
 Global types
 */

typedef struct RwBBox RwBBox;
/**
 * \ingroup datatypes
 * \struct RwBBox
 * This type represents a 3D axis-aligned bounding-box
 * specified by the positions of two corners which lie on a diagonal.
 * Typically used to specify a world bounding-box when the world is created
 * 
 * \param sup Supremum vertex
 * \param inf Infimum vertex
 * 
 * \see RpWorldCreate
 */
struct RwBBox
{
    /* Must be in this order */
    RwV3d sup;   /**< Supremum vertex. */
    RwV3d inf;   /**< Infimum vertex. */
};

#if (!defined(RwBBoxAssign))
#define RwBBoxAssign(_target, _source)            \
    ( *(_target) = *(_source) )
#endif /* (!defined(RwBBoxAssign)) */

/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern "C"
{
#endif                          /* __cplusplus */


extern RwBBox *RwBBoxCalculate(RwBBox *boundBox,
                               const RwV3d *verts,
                               RwInt32 numVerts);
extern RwBBox *RwBBoxInitialize(RwBBox *boundBox,
                                const RwV3d *vertex);
extern RwBBox *RwBBoxAddPoint(RwBBox *boundBox,
                              const RwV3d *vertex);
extern RwBool RwBBoxContainsPoint(const RwBBox *boundBox,
                                  const RwV3d *vertex);


/* LEGACY-SUPPORT macros - remove eventually */
#define _rwBoundingBoxFind(_a, _b, _c)         RwBBoxCalculate(_a, _b, _c)
#define _rwBoundingBoxInitialise(_a, _b)       RwBBoxInitialize(_a, _b)
#define _rwBoundingBoxAddPoint(_a, _b)         RwBBoxAddPoint(_a, _b)
#define _rwBoundingBoxContainsPoint(_a, _b)    RwBBoxContainsPoint(_a, _b) 

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

/* RWPUBLICEND */

#endif /* RWBBOX_H */

