/*
 * Potentially Visible Set plugin
 * Culling of World Sectors
 */

/******************************************/
/*                                        */
/*    RenderWare(TM) Graphics Library     */
/*                                        */
/******************************************/

/*
 * This file is a product of Criterion Software Ltd.
 *
 * This file is provided as is with no warranties of any kind and is
 * provided without any obligation on Criterion Software Ltd.
 * or Canon Inc. to assist in its use or modification.
 *
 * Criterion Software Ltd. and Canon Inc. will not, under any
 * circumstances, be liable for any lost revenue or other damages
 * arising from the use of this file.
 *
 * Copyright (c) 1998. Criterion Software Ltd.
 * All Rights Reserved.
 */

/***************************************************************************
 *                                                                         *
 * Module  : rppvs.h                                                       *
 *                                                                         *
 * Purpose : Culling of WSector                                            *
 *                                                                         *
 **************************************************************************/

#ifndef PVS_H
#define PVS_H

/**
 * \defgroup rppvs RpPVS
 * \ingroup rpplugin
 *
 * Potentially Visible Set Plugin for RenderWare.
 */

/****************************************************************************
 Includes
 */

#include "rpworld.h"

#include "rpcriter.h"          /* Note: each vendor can choose their own method for
                                * allocation of unique ID's. This file defines
                                * the ID's used by Criterion.
                                */
#include "rppvs.rpe"           /* automatically generated header file */

/****************************************************************************
 Defines
 */

/* Progress callback message types */
#define rpPVSPROGRESSSTART              20
#define rpPVSPROGRESSUPDATE             12
#define rpPVSPROGRESSEND                22

/* Compatibility support. */
#define RpPVSCallback                   RpPVSCallBack
#define RpPVSProgressCallback           RpPVSProgressCallBack
#define RpPVSSetProgressCallback        RpPVSSetProgressCallBack
#define RpPVSGetProgressCallback        RpPVSGetProgressCallBack

/****************************************************************************
 Global Vars
 */

/****************************************************************************
 Global Types
 */

typedef RpWorldSector *(*RpPVSCallBack) (RpWorldSector * worldSector,
                                         const RwBBox * box,
                                         void *pData);

typedef RwBool(*RpPVSProgressCallBack) (RwInt32 msg,
RwReal value);

typedef RwUInt32 RpPVSVisMap;

/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern              "C"
{
#endif                          /* __cplusplus */

#ifdef RXPIPELINE
extern RxClusterDefinition clusterPVSData;
#endif /* RXPIPELINE */

extern RwBool
_rpPVSRasterGetSize(RwInt32 *w, RwInt32 *h);

extern RwBool
_rpPVSRasterSetSize(RwInt32 w, RwInt32 h);

extern RpWorldSector *
_rpPVSAlloc(RpWorldSector * spSect,
            void *pData);

extern RpWorld *
_rpPVSAddExtraPOV(RpWorld * wpWorld,
                  RwRaster * raster,
                  RwRaster * zraster,
                  RwReal mindist,
                  RwReal maxdist,
                  RwMatrix *mat,
                  RwRaster *ras);

extern RpWorldSector *
RpPVSAddWorldSector(RpWorldSector *visible);

extern void
RpPVSAddPOV(RwV3d * pos);

extern RpWorldSector      *
RpPVSLineOfSight(RpWorldSector * spSect,
                 const RwBBox * box,
                 void *pData);

extern RpWorldSector *
RpPVSGeneric(RpWorldSector * worldSector,
             const RwBBox * box,
             void *pData);

extern RpWorld *
RpPVSCreate(RpWorld * wpWorld,
            RwRaster * ras,
            RwRaster * zras,
            RwReal mindist,
            RwReal maxdist,
            RwInt32 maxdepth,
            RpPVSCallBack callback,
            void *pData);

extern RpWorld *
RpPVSAddExtraPOV(RpWorld * wpWorld,
                 RwRaster * raster,
                 RwRaster * zraster,
                 RwReal mindist,
                 RwReal maxdist,
                 RwMatrix *mat);

extern RpWorld *
RpPVSSetProgressCallBack(RpWorld * world,
                         RpPVSProgressCallBack callback);

extern RpPVSProgressCallBack
RpPVSGetProgressCallBack(RpWorld * world);

extern RpWorld *
RpPVSHook(RpWorld * wpWorld);

extern RpWorld *
RpPVSUnhook(RpWorld * wpWorld);

extern RpWorld *
RpPVSDestroy(RpWorld * wpWorld);

extern RpWorld *
RpPVSSetViewPosition(RpWorld * wpWorld,
                     RwV3d * pos);

extern RwBool
RpPVSWorldSectorVisible(RpWorldSector *spSect);

extern RwBool
RpPVSAtomicVisible(RpAtomic *atom);

extern RwBool
RpPVSQuery(RpWorld * wpWorld);

extern RpWorld *
RpPVSStatisticsGet(RpWorld * wpWorld,
                   RwInt32 * ptotal,
                   RwInt32 * paccept);

extern RwBool
RpPVSPluginAttach(void);

#ifdef RXPIPELINE
extern RxNodeDefinition  *
RxNodeDefinitionGetPVSWorldSectorCSL(void);

#endif /* RXPIPELINE */

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

#if (!defined(_RpPVSAddExtraPOV))
#define _RpPVSAddExtraPOV(_wpWorld, _raster, _zraster, _mindist, _maxdist, _mat, _ras) \
        _rpPVSAddExtraPOV(_wpWorld, _raster, _zraster, _mindist, _maxdist, _mat, _ras)
#endif /* (!defined(_RpPVSAddExtraPOV)) */

#endif                          /* PVS_H */
