/*
 * Skin plug-in
 */

/****************************************************************************
 *                                                                          *
 *  Module  :   skinEnvPipe.c                                               *
 *                                                                          *
 *  Purpose :   Skin Dual Pass mapping pipeline for PS2                     *
 *                                                                          *
 ****************************************************************************/


/****************************************************************************
 Includes
 */
#include <rpdbgerr.h>
#include <rpmatfx.h>
#include <rpskin.h>

#include "../../driver/sky2/baasm.h"

#include "rpplugin.h"
#include "effectPipes.h"
#include "effectPipesSky.h"

#include "SKY2_SkinAlphaBlender/stddata.h"
#include "SKY2_SkinAlphaBlender/skinDualPassPipe.h"

/*----------------------------------------------------------------------*/
/*-                                Definition                          -*/
/*----------------------------------------------------------------------*/
matFXVUcode RWALIGN(skySkinAlphaBlenderTransforms, rpMATFXALIGNMENT) =
{
    &SkinAlphaBlenderPRS, &vu1nullTrans,
    &SkinAlphaBlenderPRL, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans
};

/*==========================================================================*/
/*                                                                          */
/*                               Functions                                  */
/*                                                                          */
/*==========================================================================*/
RwBool
_rpMatFXSkinDualInstanceCallBack( void **clusterData,
                                  RwUInt32 __RWUNUSED__ numClusters )
{
    /* --------------- Pipe --------------------------------------*/
    RxPS2Mesh *mesh = (RxPS2Mesh *)clusterData[0];
    RxPS2DMASessionRecord *dmaSessionRec =
        (RxPS2DMASessionRecord *)clusterData[1];
    rpMatFXMaterialData *materialData =
        (rpMatFXMaterialData *)*MATFXMATERIALGETDATA(mesh->mesh->material);
    /* --------------- Skin --------------------------------------*/
    RpAtomic  *atomic     = dmaSessionRec->sourceObject.atomic;
    RpSkin    *skin      = *MATFXSKINATOMICGETDATA(atomic);
    RwUInt32  numMatrices = skin->numBones;
    RwReal    *destMBI    = (RwReal *)(clusterData[2]);
    RwInt32   DMAstorage  = 0;
    RwMatrix  *pMBA       = (RwMatrix *) NULL;
    /*---------------- Dual --------------------------------------*/
    RwTexture *texture;
    RwRaster  *blenderRaster;
    RwUInt64  alpha_2;
    RwUInt64  clamp_2;
    RwUInt64  test_2;

    RWFUNCTION(RWSTRING("_rpMatFXSkinDualInstanceCallBack"));

    RWASSERT(NULL != mesh);
    RWASSERT(NULL != dmaSessionRec);
    RWASSERT(NULL != destMBI);
    RWASSERT(NULL != atomic);
    RWASSERT(NULL != skin);
    RWASSERT(NULL != skin->pCurrentHierarchy);

    /* Grab our data. */
    texture = materialData->data[rpSECONDPASS].data.dual.texture;
    alpha_2 = materialData->data[rpSECONDPASS].data.dual.alpha_2;
    clamp_2 = materialData->data[rpSECONDPASS].data.dual.clamp_2;
    test_2 = materialData->data[rpSECONDPASS].data.dual.test_2;

    if (NULL != texture)
    {
        blenderRaster = RwTextureGetRaster(texture);
    }
    else
    {
        blenderRaster = (RwRaster *) NULL;
    }

    /*------------ Skin weights and indices instancing -----------*/
    if (dmaSessionRec->serialNum != ((RwUInt32 *) (*(mesh->cacheEntryRef) + 1))[3])
    {
        matFXSkinning.skinMBWeightsInstancing(mesh->mesh, skin, destMBI);
    }

    /*----------------- Bones matrices uploading -----------------*/
    if (matFXSkinning.skinAtomicGlobals->SkinMatrixCacheSkin != skin ||
        matFXSkinning.skinAtomicGlobals->SkinMatrixCacheRenderFrame != RWSRCGLOBAL(renderFrame))
    {
        pMBA           = matFXSkinning.skinMBMatUpdating(atomic, skin);
        RWASSERT(NULL != pMBA);
        DMAstorage     = numMatrices * 4;
    }

    /*----------------- DMA data Upload --------------------------*/
    {
        RwUInt64            prim        = 0x0l;
        RwUInt64            primSwitch  = 0x4l;
        RwUInt64            fogSwitch   = 0x0l;
        RwUInt32            rasmsb      = 0;
        RwUInt32            raslsb      = 0;
        u_long128           ltmp        = 0;
        RwUInt64            tmp, tmp1;

        /*--------------- set the prim type -----------------*/
        if (dmaSessionRec->transType & 4)
        {
            primSwitch = 0x3l;
        }
        /*--------------- set the fog -----------------------*/
        if (dmaSessionRec->transType & 1)
        {
            fogSwitch = 0x1l;
        }

        /*--- Need to upload the base texture ---*/
        _rpMatFXUploadTexture(mesh->mesh->material->texture, dmaSessionRec,
                              mesh);

        /*------ Upload the second texture ------*/
        if (NULL != blenderRaster)
        {
            skyTexCacheAccessRaster(blenderRaster, TRUE);
        }

        /*---------------- DMA packet -----------------------*/
        sweFinaliseOpenLocalPkt(SWE_LPS_NOFIXUP |
                                SWE_PKT_DMA_MODE_CHAIN_TTE |
                                SWE_PKT_LOCAL | SWE_PKT_VU1 |
                                SWE_PKT_CIRCALLOC,
                                -(12 + DMAstorage));
        if (!sweLocalPacket)
        {
            RWRETURN(FALSE);
        }
        tmp  = ((1l << 28) | (DMAstorage + 10));
        tmp1 = ((((0x6cl << 24)               |
               ((DMAstorage + 5) << 16)      |
               ((long) (pipeASymbSkinStaticDualPassStart))) << 32) |
               ((1l << 24) | (4 << 8) | (4)));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);
        /*---------------------------------------------------*/

        /*------ 2nd Context Giftag -------------*/
        prim = ( /* fix  */ 0x0l << 10 |
                /* ctxt */ 0x1l << 9 |
                /* fst  */ 0x0l << 8 |
                /* aa1  */ 0x0l << 7 |
                /* abe  */ 0x1l << 6 |
                /* fge  */ fogSwitch << 5 |
                /* tme  */ 0x1l << 4 |
                /* iip  */ 0x1l << 3 |
                /* prim */ primSwitch << 0);
        tmp = ( /* regs */ 0x3l << (60 - 32) |
                /* flg  */ 0x0l << (58 - 32) |
                /* prim */ prim << (47 - 32) |
                /* pre  */ 0x1l << (46 - 32)) << 32;
        /* registers */
        MAKE128(ltmp, 0x412l, tmp);
        SWEADDCONTFAST(ltmp);

        /*--------- Palette info context 1 ------------------*/
        tmp = /* NLOOP */ 1l
            | /* EOP   */ (1l << 15)
            | /* PRE   */ (0l << 46)
            | /* FLG   */ (0l << 58)
            | /* NREG  */ (1l << 60);
        tmp1 = /* A+D */ (0xel << (64 - 64));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);
        /*-------- Tex 0-1 ---------------*/
        skyTexGetTex0(mesh->mesh->material->texture->raster,
                      &rasmsb, &raslsb);
        tmp = ((RwUInt64) rasmsb << 32) | raslsb;
        MAKE128(ltmp, GS_TEX0_1, tmp);
        SWEADDCONTFAST(ltmp);

        /*--------- Palette info context 2 ------------------*/
        tmp = /* NLOOP */ 1l
            | /* EOP   */ (1l << 15)
            | /* PRE   */ (0l << 46)
            | /* FLG   */ (0l << 58)
            | /* NREG  */ (1l << 60);
        tmp1 = /* A+D */ (0xel << (64 - 64));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);
       /*-------- Tex 0-2 ---------------*/
        skyTexGetTex0(blenderRaster, &rasmsb, &raslsb);
        tmp = ((RwUInt64) rasmsb << 32) | raslsb;
        MAKE128(ltmp, GS_TEX0_2, tmp);
        SWEADDCONTFAST(ltmp);

        /*-------- Upload Skin matrices ---------------------*/
        if(DMAstorage)
        {
            RwUInt32  i;
            for (i = 0; i < numMatrices; i++)
            {
                ltmp = *((u_long128 *) & pMBA->right.x);
                SWEADDCONTFAST(ltmp);
                ltmp = *((u_long128 *) & pMBA->up.x);
                SWEADDCONTFAST(ltmp);
                ltmp = *((u_long128 *) & pMBA->at.x);
                SWEADDCONTFAST(ltmp);
                ltmp = *((u_long128 *) & pMBA->pos.x);
                SWEADDCONTFAST(ltmp);
                pMBA++;
            }
        }
        /*---------------------------------------------------*/

        /*------------ Padding ------------------------------*/
        tmp = VIFCMD_NOP | (VIFCMD_NOP << 32);
        tmp1 = (VIFCMD_NOP) | ((VIFCMD_DIRECT | 4) << 32);
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*------------- Second Context Registers ------------*/
        tmp = /* NLOOP */ 3l
            | /* EOP   */ (1l << 15)
            | /* PRE   */ (0l << 46)
            | /* FLG   */ (0l << 58)
            | /* NREG  */ (1l << 60);
        tmp1 = /* A+D */ (0xel << (64 - 64));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*--- 2nd context Alpha register settings ---*/
        MAKE128(ltmp, GS_ALPHA_2, (8l << 32) | alpha_2);
        SWEADDCONTFAST(ltmp);

        /*--- 2nd context Clamp register settings ---*/
        MAKE128(ltmp, GS_CLAMP_2, clamp_2);
        SWEADDCONTFAST(ltmp);

        /*--- 2nd context Alpha register settings ---*/
        MAKE128(ltmp, GS_TEST_2, test_2);
        SWEADDCONTFAST(ltmp);

        /*------- Terminate the DMA with an interrupt -------*/
        tmp = (0xfl << 28);
        MAKE128(ltmp, 0l, tmp);
        SWEADDCONTFAST(ltmp);
        /*---------------------------------------------------*/

        sweFinaliseOpenLocalPkt(SWE_LPS_CONT, 0);
    }

    RWRETURN(TRUE);
}
