/*----------------------------------------------------------------------*/
/*-                             Includes                               -*/
/*----------------------------------------------------------------------*/
#include <rpdbgerr.h>
#include <rpmatfx.h>

#include "../../driver/sky2/baasm.h"

#include "rpplugin.h"
#include "effectPipes.h"
#include "effectPipesSky.h"

#include "SKY2_GlosEnvMap/envPipe.h"
#include "SKY2_GlosEnvMap/stddata.h"

/*----------------------------------------------------------------------*/
/*-                                Definition                          -*/
/*----------------------------------------------------------------------*/
matFXVUcode RWALIGN(skyEnvMapTransforms, rpMATFXALIGNMENT) = 
{
    &GlosEnvMapPRS, &vu1nullTrans,
    &GlosEnvMapPRL, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans
};

/*----------------------------------------------------------------------*/
/*-                                Functions                           -*/
/*----------------------------------------------------------------------*/
RwBool
_rpMatFXEnvMapInstanceCallBack( void **clusterData,
                                    RwUInt32 __RWUNUSED__ numClusters )
{
    /* --------------- Pipe --------------------------------------*/
    RxPS2Mesh *mesh = (RxPS2Mesh *)clusterData[0];
    RxPS2DMASessionRecord *dmaSessionRec =
        (RxPS2DMASessionRecord *)clusterData[1];
    rpMatFXMaterialData *materialData = 
        (rpMatFXMaterialData *)*MATFXMATERIALGETDATA(mesh->mesh->material);
    /* --------------- Env Map -----------------------------------*/
    RwTexture          *envMapTexture = (RwTexture *) NULL;
    RwRaster           *envMapRaster = (RwRaster *) NULL;
    RwReal              envMapCoef = 0.0f;
    RwUInt64            primSwitch = 0x4l;
    RwUInt64            fogSwitch = 0x0l;

    /*-- 0 : additive - 1 : use Frame Buffer alpha --*/
    RwBool              blendmode;

    RWFUNCTION(RWSTRING("_rpMatFXEnvMapInstanceCallBack"));
    RWASSERT(mesh);
    RWASSERT(materialData);

    blendmode = materialData->data[rpSECONDPASS].data.envMap.
        useFrameBufferAlpha;
    envMapCoef = materialData->data[rpSECONDPASS].data.envMap.coef;
    envMapTexture =
        materialData->data[rpSECONDPASS].data.envMap.texture;
    RWASSERT(envMapTexture);

    envMapRaster = RwTextureGetRaster(envMapTexture);
    RWASSERT(envMapRaster);

    /*--------------- set the prim type ----------*/
    if (dmaSessionRec->transType & 4)
    {
        /*--- Tri-list Setting 2nd context ---*/
        primSwitch = 0x3l;
    }
    /*--------------- set the fog ----------------*/
    if (dmaSessionRec->transType & 1)
    {
        /*--- 2nd context fog activated ------*/
        fogSwitch = 0x1l;
    }
    {
        u_long128           ltmp = 0;
        u_long128          *u;
        RwUInt64            tmp, tmp1;
        RwUInt64            prim = 0x0l;
        RwUInt32            rasmsb = 0;
        RwUInt32            raslsb = 0;

        /*--- Need to upload the base texture ---*/
        _rpMatFXUploadTexture(mesh->mesh->material->texture, dmaSessionRec,
                              mesh);

        /*--- Now upload the envMap texture -----*/
        skyTexCacheAccessRaster(envMapRaster, TRUE);

        /*------ 18 QW to be sent ---------------*/
        sweFinaliseOpenLocalPkt((int) (SWE_PKT_DMA_MODE_CHAIN_TTE |
                                       SWE_PKT_LOCAL |
                                       SWE_PKT_VU1 |
                                       SWE_PKT_CIRCALLOC), -18);
        /* 16 QW */
        tmp = ((1l << 28) | (16));
        /* 11 QW */
        tmp1 = ((((0x6cl << 24) | (11l << 16) |
                  ((long) (pipeASymbStaticEnvDataStart))) << 32) |
                ((1l << 24) | (4 << 8) | (4)));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*---------- Dark Fog Tag / Tex0-2 Info -----------*/
        tmp = ( /* NLOOP */ 2l
              | /* EOP   */ (1l << 15)
              | /* PRE   */ (0l << 46)
              | /* FLG   */ (0l << 58)
              | /* NREG  */ (1l << 60) );
        tmp1 = /* A+D */ (0xel << (64 - 64));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);
        /*
         * Dark fog is needed on additive alpha blending
         */
        tmp = 0x000000l;
        MAKE128(ltmp, GS_FOGCOL, tmp);
        SWEADDCONTFAST(ltmp);
        /*
         * Tex 0-2 is needed for palettized 2nd texture
         */
        skyTexGetTex0(envMapRaster, &rasmsb, &raslsb);
        tmp = ((RwUInt64) rasmsb << 32) | raslsb;
        MAKE128(ltmp, GS_TEX0_2, tmp);
        SWEADDCONTFAST(ltmp);

        /*-------Real Fog Tag / Tex0-1 Info ---------------*/
        tmp = /* NLOOP */ 2l
            | /* EOP   */ (1l << 15)
            | /* PRE   */ (0l << 46)
            | /* FLG   */ (0l << 58)
            | /* NREG  */ (1l << 60);
        tmp1 = /* A+D */ (0xel << (64 - 64));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);
        /*
         * Dark fog is needed on additive alpha blending
         */
        tmp = skyFogcol;
        MAKE128(ltmp, GS_FOGCOL, tmp);
        SWEADDCONTFAST(ltmp);
        /*
         * Tex 0-1 is needed to restore 1st texture palette
         */
        skyTexGetTex0(mesh->mesh->material->texture->raster,
                      &rasmsb, &raslsb);
        tmp = ((RwUInt64) rasmsb << 32) | raslsb;
        MAKE128(ltmp, GS_TEX0_1, tmp);
        SWEADDCONTFAST(ltmp);

        /*----------- Context 2 Env-Map GifTag ------------*/
        prim = ( /* fix  */ 0x0l << 10 |
                /* ctxt */ 0x1l << 9 |
                /* fst  */ 0x0l << 8 |
                /* aa1  */ 0x0l << 7 |
                /* abe  */ 0x1l << 6 |
                /* fge  */ fogSwitch << 5 |
                /* tme  */ 0x1l << 4 |
                /* iip  */ 0x1l << 3 |
                /* prim */ primSwitch << 0);
        tmp = ( /* regs */ 0x3l << (60 - 32) |
               /* flg  */ 0x0l << (58 - 32) |
               /* prim */ prim << (47 - 32) |
               /* pre  */ 0x1l << (46 - 32)) << 32;
        /* registers */
        tmp1 = 0x412l;
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*------------ Env Map matrix -----------------------*/
        u = (u_long128 *) & (matFXEnvMatrix.right);
        ltmp = *u;
        SWEADDCONTFAST(ltmp);
        u = (u_long128 *) & (matFXEnvMatrix.up);
        ltmp = *u;
        SWEADDCONTFAST(ltmp);
        tmp = *(const RwUInt64 *) & (matFXEnvMatrix.at.x);
        tmp1 = *(const RwUInt32 *) & (envMapCoef);
        tmp1 = ((tmp1 << 32) | (*(const RwUInt32 *) & (matFXEnvMatrix.at.z)));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*------------ Environment Map Datas ----------------*/
        tmp = *(const RwUInt64 *) (matFXEnvParams);
        tmp1 = *(const RwUInt64 *) (matFXEnvParams + 2);
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*------------ Padding ------------------------------*/
        tmp = VIFCMD_NOP | (VIFCMD_NOP << 32);
        tmp1 = (VIFCMD_NOP) | ((VIFCMD_DIRECT | 4) << 32);
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*------------- Second Context Registers ------------*/
        tmp = /* NLOOP */ 3l
            | /* EOP   */ (1l << 15)
            | /* PRE   */ (0l << 46)
            | /* FLG   */ (0l << 58)
            | /* NREG  */ (1l << 60);
        tmp1 = /* A+D */ (0xel << (64 - 64));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        if (blendmode)
        {
            /*-- Blend mode is Cf = Cd + Ad x Cs --*/
            tmp = 0x8000000058l;
        }
        else
        {
            /*-- Blend mode is Cf = Cd + Cs -------*/
            tmp = 0x8000000068l;
        }
        MAKE128(ltmp, GS_ALPHA_2, tmp);
        SWEADDCONTFAST(ltmp);

        /*---- Repeat texture ----*/
        tmp = 0x0;
        MAKE128(ltmp, GS_CLAMP_2, tmp);
        SWEADDCONTFAST(ltmp);

        /*---- No alpha test -----*/
        tmp = 0x50002l;
        MAKE128(ltmp, GS_TEST_2, tmp);
        SWEADDCONTFAST(ltmp);

        /*------- Terminate the DMA with an interrupt -------*/
        tmp = (0xfl << 28);
        MAKE128(ltmp, 0l, tmp);
        SWEADDCONTFAST(ltmp);

        /*---------------------------------------------------*/
        sweFinaliseOpenLocalPkt(SWE_LPS_CONT, 0);
    }
    RWRETURN(TRUE);
}
