/*----------------------------------------------------------------------*/
/*-                             Includes                               -*/
/*----------------------------------------------------------------------*/
#include <rpdbgerr.h>
#include <rpmatfx.h>

#include "../../driver/sky2/baasm.h"

#include "rpplugin.h"
#include "effectPipes.h"
#include "effectPipesSky.h"

#include "SKY2_BumpMapping/bumpPipe.h"
#include "SKY2_BumpMapping/stddata.h"

/*----------------------------------------------------------------------*/
/*-                                Definition                          -*/
/*----------------------------------------------------------------------*/
matFXVUcode RWALIGN(skyBumpMapTransforms, rpMATFXALIGNMENT) = 
{
    &BumpMappingPRS, &vu1nullTrans,
    &BumpMappingPRL, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans, &vu1nullTrans
};

/*----------------------------------------------------------------------*/
/*-                                Functions                           -*/
/*----------------------------------------------------------------------*/
RwBool
_rpMatFXBumpInstanceCallBack( void **clusterData,
                              RwUInt32 __RWUNUSED__ numClusters )
{
    /* --------------- Pipe --------------------------------------*/
    RxPS2Mesh *mesh = (RxPS2Mesh *)clusterData[0];
    RxPS2DMASessionRecord *dmaSessionRec =
        (RxPS2DMASessionRecord *)clusterData[1];
    rpMatFXMaterialData *materialData = 
        (rpMatFXMaterialData *)*MATFXMATERIALGETDATA(mesh->mesh->material);
    /* --------------- Bump map ----------------------------------*/
    RwReal     bumpCoef;
    RwTexture *texture;

    RWFUNCTION(RWSTRING("_rpMatFXBumpInstanceCallBack"));
    RWASSERT(mesh);
    RWASSERT(materialData);

    bumpCoef = materialData->data[rpSECONDPASS].data.bumpMap.coef *
        materialData->data[rpSECONDPASS].data.bumpMap.invBumpWidth;

    texture = materialData->data[rpSECONDPASS].data.bumpMap.texture;
    RWASSERT(texture);

    /* Do we have a bumpMap texture? */
    if (NULL == texture)
    {
        /* No - then lets borrow the material one. */
        texture = mesh->mesh->material->texture;
    }

    {
        u_long128           ltmp = 0;
        RwUInt64            tmp, tmp1;

        /*---- Stealth function ----*/

        /* We send 16 QW in DMA transfer */
        sweFinaliseOpenLocalPkt((int) (SWE_PKT_DMA_MODE_CHAIN_TTE |
                                       SWE_PKT_LOCAL |
                                       SWE_PKT_VU1 |
                                       SWE_PKT_CIRCALLOC), -12);

        /*------------------------------------------------------------*/
        /* 10 QW are effective */
        tmp = ((1l << 28) | (10));
        /* 10 are in Upper memory */
        tmp1 = ((((0x6cl << 24) | (10l << 16) |
                  ((long) (pipeASymbStaticBumpDataStart))) << 32) |
                ((1l << 24) | (4 << 8) | (4)));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*------------------ Emboss Bump Data --------------*/
        /* Emboss Bump Mapping Coefficient */
        tmp = (*(const RwUInt32 *) &bumpCoef);
        /* FX End effector plan */
        tmp1 = (*(const RwUInt32 *) &matFXBumpFarPlane);
        /* FX Scale Factor (similar to fog calculation) */
        tmp1 = ((tmp1 << 32) | (*(const RwUInt32 *) &matFXBumpScale));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*------------------ Bump CTX1 Bump Tag2 ------------*/
        /* First pass bump map tag modifyer */
        tmp = /* NLOOP */ 2l
            | /* EOP   */ (1l << 15)
            | /* PRE   */ (0l << 46)
            | /* FLG   */ (0l << 58)
            | /* NREG  */ (1l << 60);
        tmp1 = /* A+D */ (0xel << (64 - 64));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /* Sets blending to : Cf = Cs x (1.-As) */
        tmp = 0x8000000002l;
        tmp1 = GS_ALPHA_1;
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /* No Alpha test and alpha notifications */
        tmp = 0x50002l;
        tmp1 = GS_TEST_1;
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*------------------ Bump CTX1 Bump Tag1 ------------*/
        /* Second pass bump map tag modifyer */
        tmp = /* NLOOP */ 2l
            | /* EOP   */ (1l << 15)
            | /* PRE   */ (0l << 46)
            | /* FLG   */ (0l << 58)
            | /* NREG  */ (1l << 60);
        tmp1 = /* A+D */ (0xel << (64 - 64));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /* Sets blending to : Cf = Cd + As x Cs */
        tmp = 0x8000000048l;
        tmp1 = GS_ALPHA_1;
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /* No Alpha test and alpha notifications */
        tmp = 0x50002l;
        tmp1 = GS_TEST_1;
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*------------ Bump Map matrix ----------------------*/
        {
            u_long128          *u;

            u = (u_long128 *) & (matFXBumpMatrix.right);
            ltmp = *u;
            SWEADDCONTFAST(ltmp);

            u = (u_long128 *) & (matFXBumpMatrix.up);
            ltmp = *u;
            SWEADDCONTFAST(ltmp);

            u = (u_long128 *) & (matFXBumpMatrix.at);
            ltmp = *u;
            SWEADDCONTFAST(ltmp);

        }

        /*------- Terminate the DMA with an interrupt -------*/
        tmp = (0xfl << 28);
        MAKE128(ltmp, 0l, tmp);
        SWEADDCONTFAST(ltmp);

        /*---------------------------------------------------*/
        sweFinaliseOpenLocalPkt(SWE_LPS_CONT, 0);
    }

    /*---- Stealth function ----*/

    /* Lets upload the bumpMap texture. */
    _rpMatFXUploadTexture(texture, dmaSessionRec, mesh);

    RWRETURN(TRUE);
}
