/*----------------------------------------------------------------------*/
/*-                             Includes                               -*/
/*----------------------------------------------------------------------*/
#include <rpdbgerr.h>
#include <rpmatfx.h>

#include "../../driver/sky2/baasm.h"

#include "rpplugin.h"
#include "effectPipes.h"
#include "effectPipesSky.h"

#include "SKY2_AlphaBlender/dualPassPipe.h"
#include "SKY2_AlphaBlender/stddata.h"

/*----------------------------------------------------------------------*/
/*-                                Definition                          -*/
/*----------------------------------------------------------------------*/
matFXVUcode RWALIGN(skyAlphaBlenderTransforms, rpMATFXALIGNMENT) = 
{
    &AlphaBlenderPRS, &vu1nullTrans,
    &AlphaBlenderPRL, &vu1nullTrans,
    &vu1nullTrans,    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans,    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans,    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans,    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans,    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans,    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans,
    &vu1nullTrans,    &vu1nullTrans, &vu1nullTrans, &vu1nullTrans
};

/*----------------------------------------------------------------------*/
/*-                                Functions                           -*/
/*----------------------------------------------------------------------*/
RwBool
_rpMatFXDualInstanceCallBack( void **clusterData,
                              RwUInt32 __RWUNUSED__ numClusters )
{
    /* --------------- Pipe --------------------------------------*/
    RxPS2Mesh *mesh = (RxPS2Mesh *)clusterData[0];
    RxPS2DMASessionRecord *dmaSessionRec =
        (RxPS2DMASessionRecord *)clusterData[1];
    rpMatFXMaterialData *materialData = 
        (rpMatFXMaterialData *)*MATFXMATERIALGETDATA(mesh->mesh->material);
    /* --------------- Dual --------------------------------------*/
    RwTexture          *texture;
    RwRaster           *blenderRaster;
    RwUInt64            alpha_2;
    RwUInt64            clamp_2;
    RwUInt64            test_2;
    RwUInt64            primSwitch = 0x4l;
    RwUInt64            fogSwitch = 0x0l;

    RWFUNCTION(RWSTRING("_rpMatFXDualInstanceCallBack"));
    RWASSERT(mesh);
    RWASSERT(materialData);

    /* Grab our data. */
    texture = materialData->data[rpSECONDPASS].data.dual.texture;
    alpha_2 = materialData->data[rpSECONDPASS].data.dual.alpha_2;
    clamp_2 = materialData->data[rpSECONDPASS].data.dual.clamp_2;
    test_2 = materialData->data[rpSECONDPASS].data.dual.test_2;

    if (NULL != texture)
    {
        blenderRaster = RwTextureGetRaster(texture);
    }
    else
    {
        blenderRaster = (RwRaster *) NULL;
    }

    /*---- 2nd Context prim setting ----*/
    if (dmaSessionRec->transType & 4)
    {
        /*--- Tri-list -----*/
        primSwitch = 0x3l;
    }
    /*---- 2nd context fog setting -----*/
    if (dmaSessionRec->transType & 1)
    {
        /*--- Fog active ---*/
        fogSwitch = 0x1l;
    }
    {
        u_long128           ltmp = 0;
        RwUInt64            tmp, tmp1;
        RwUInt64            prim = 0x0l;
        RwUInt32            rasmsb = 0;
        RwUInt32            raslsb = 0;

        /*--- Need to upload the base texture ---*/
        _rpMatFXUploadTexture(mesh->mesh->material->texture, dmaSessionRec,
                              mesh);

        /*------ Upload the second texture ------*/
        if (NULL != blenderRaster)
        {
            skyTexCacheAccessRaster(blenderRaster, TRUE);
        }
        /*------- 12 QW to be sent ---------------*/
        sweFinaliseOpenLocalPkt((int) (SWE_PKT_DMA_MODE_CHAIN_TTE |
                                       SWE_PKT_LOCAL |
                                       SWE_PKT_VU1 |
                                       SWE_PKT_CIRCALLOC), -12);
        /* 10 QW */
        tmp = ((1l << 28) | (10));
        /* 5 QW */
        tmp1 = ((((0x6cl << 24) | (5l << 16) |
                  ((long) (pipeASymbStaticDualPassStart))) << 32) |
                ((1l << 24) | (4 << 8) | (4)));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*------ 2nd Context Giftag -------------*/
        prim = ( /* fix  */ 0x0l << 10 |
                /* ctxt */ 0x1l << 9 |
                /* fst  */ 0x0l << 8 |
                /* aa1  */ 0x0l << 7 |
                /* abe  */ 0x1l << 6 |
                /* fge  */ fogSwitch << 5 |
                /* tme  */ 0x1l << 4 |
                /* iip  */ 0x1l << 3 |
                /* prim */ primSwitch << 0);
        tmp = ( /* regs */ 0x3l << (60 - 32) |
               /* flg  */ 0x0l << (58 - 32) |
               /* prim */ prim << (47 - 32) |
               /* pre  */ 0x1l << (46 - 32)) << 32;
        /* registers */
        tmp1 = 0x412l;
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*--------- Palette info context 1 ------------------*/
        tmp = /* NLOOP */ 1l
            | /* EOP   */ (1l << 15)
            | /* PRE   */ (0l << 46)
            | /* FLG   */ (0l << 58)
            | /* NREG  */ (1l << 60);
        tmp1 = /* A+D */ (0xel << (64 - 64));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);
        /*
         * Tex 0-1 is needed for palettized 2nd texture
         */
        skyTexGetTex0(mesh->mesh->material->texture->raster,
                      &rasmsb, &raslsb);
        tmp = ((RwUInt64) rasmsb << 32) | raslsb;
        MAKE128(ltmp, GS_TEX0_1, tmp);
        SWEADDCONTFAST(ltmp);

        /*--------- Palette info context 2 ------------------*/
        tmp = /* NLOOP */ 1l
            | /* EOP   */ (1l << 15)
            | /* PRE   */ (0l << 46)
            | /* FLG   */ (0l << 58)
            | /* NREG  */ (1l << 60);
        tmp1 = /* A+D */ (0xel << (64 - 64));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);
        /*
         * Tex 0-2 is needed for palettized 2nd texture
         */
        skyTexGetTex0(blenderRaster, &rasmsb, &raslsb);
        tmp = ((RwUInt64) rasmsb << 32) | raslsb;
        MAKE128(ltmp, GS_TEX0_2, tmp);
        SWEADDCONTFAST(ltmp);

        /*------------ Padding ------------------------------*/
        tmp = VIFCMD_NOP | (VIFCMD_NOP << 32);
        tmp1 = (VIFCMD_NOP) | ((VIFCMD_DIRECT | 4) << 32);
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);
        /*---------------------------------------------------*/

        /*------------- Second Context Registers ------------*/
        tmp = /* NLOOP */ 3l
            | /* EOP   */ (1l << 15)
            | /* PRE   */ (0l << 46)
            | /* FLG   */ (0l << 58)
            | /* NREG  */ (1l << 60);
        tmp1 = /* A+D */ (0xel << (64 - 64));
        MAKE128(ltmp, tmp1, tmp);
        SWEADDCONTFAST(ltmp);

        /*--- 2nd context Alpha register settings ---*/
        tmp = (8l << 32) | alpha_2;
        MAKE128(ltmp, GS_ALPHA_2, tmp);
        SWEADDCONTFAST(ltmp);

        /*--- 2nd context Clamp register settings ---*/
        tmp = clamp_2;
        MAKE128(ltmp, GS_CLAMP_2, tmp);
        SWEADDCONTFAST(ltmp);

        /*--- 2nd context Alpha register settings ---*/
        tmp = test_2;
        MAKE128(ltmp, GS_TEST_2, tmp);
        SWEADDCONTFAST(ltmp);

        /*------- Terminate the DMA with an interrupt -------*/
        tmp = (0xfl << 28);
        MAKE128(ltmp, 0l, tmp);
        SWEADDCONTFAST(ltmp);

        /*---------------------------------------------------*/
        sweFinaliseOpenLocalPkt(SWE_LPS_CONT, 0);
    }
    RWRETURN(TRUE);
}
