
/****************************************************************************
 *                                                                         
 * VRML 2.0 to RW3.0 Converter
 * Copyright (C) 1998 Criterion Technologies
 *
 * Author  : Damian Scallan 
 *
 * Module  : Utilities.c
 *                                                                         
 * Purpose : Useful expoter functions which will eventually move into RW tools
 *                                                                         
 ****************************************************************************/

#ifndef UTILITIES_H
#define UTILITIES_H

/* #define rwPL_ERRFILE errvrml */

/****************************************************************************
 Includes
 */
#include <stdio.h>
#include <stdlib.h>

#include "_rpvrml.h"

/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern "C"
{
#endif         /* __cplusplus */

    RpClump *ClumpFrameNormalize(RpClump * clump);
    RpClump *ClumpRemoveDummyFrames(RpClump * clump);

    RpGeometry *_rpVrmlGeometryAddCreaseNormals(RpGeometry * geometry,
                                           RwReal creaseAngle);

/* initial field block stuff */

    typedef struct MemBlock  MemBlock;
    struct MemBlock
    {
        MemBlock *nextBlock;
        /* void *currentElement; */
        int numUsedElements;
        void *mem;
    };
    

    typedef struct FieldBlock FieldBlock;
    struct FieldBlock
    {
        MemBlock *currentBlock;
        MemBlock *delBlock;
        void *currentElement;
        int elementSize;
        int numElements;
        int blockSize;
        int numUsedElements;
    };
    
    

    FieldBlock *FieldBlock_Create(int elementSize, int numElements);
    int FieldBlock_Destroy(FieldBlock * fb);
    void *FieldBlock_GetElement(FieldBlock * fb);
    int FieldBlock_ReleaseElement(FieldBlock * fb);
    int FieldBlock_ReleaseElemnetII(FieldBlock * fb, void *element);
    int FieldBlock_Compact(FieldBlock * fb);

    RwMatrix *MatrixSetAtPos(RwMatrix * matrix, RwV3d * at,
                             RwV3d * pos);
    RwV3d *VerctorPerpendicular(RwV3d * out, RwV3d * in);

#ifdef    __cplusplus
}
#endif         /* __cplusplus */

#endif         /* UTILITIES_H */
