
/****************************************************************************
 * 
 * VRML 2.0 to RW3.0 Converter
 * Copyright (C) 1997 Criterion Technologies
 *
 * Author  : Damian Scallan 
 *
 * Module  : Stack.h
 *                                                                         
 * Purpose : Polymorphic stack + methods
 *
 ****************************************************************************/

#ifndef STACK_H
#define STACK_H

/****************************************************************************
 Includes
 */

#include <stdlib.h>
#include "_rpvrml.h"
#include "types.h"
#include "llinklist.h"

/****************************************************************************
 Global Types
 */

typedef struct LLStack LLStack;
struct LLStack
{
    int Items;
    LLinkList StackList;
};

/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern "C"
{
#endif         /* __cplusplus */

    void Stack_Init(LLStack * Stack);
    VRMLBool Stack_IsEmpty(LLStack * Stack);
    void *Stack_Pop(LLStack * Stack);
    void *Stack_Top(LLStack * Stack);
    VRMLBool Stack_Push(LLStack * Stack, void *Data);

#ifdef    __cplusplus
}
#endif         /* __cplusplus */

#endif         /* STACK_H */
