/*
 *
 * VRML to RW converter plug-in
 */

/****************************************************************************
 *    
 * VRML 2.0 to RW3.0 Converter
 * Copyright (C) 1997 Criterion Technologies
 *
 * Author  : Damian Scallan 
 *
 * Module  : LogFile.c
 *                                                                         
 * Purpose : Handles the log file creation and message dispatch in an RWDEBUG
 *           build.
 *          
 ****************************************************************************/

/****************************************************************************
 Includes
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "rpplugin.h"
#include <rpdbgerr.h>
#include "rpvrmlanim.h"
#include "rpvrml.h"
#include "logfile.h"

static const char __RWUNUSED__ rcsid[] =
    "@@(#)$Id: logfile.c,v 1.19 2001/01/26 12:10:37 johns Exp $";

/****************************************************************************
 Local Defines
 */

#define LOGFILE "vrmllog"
#define MAXLINELEN (80)
#define INDENT (4)

/****************************************************************************
 Local (static) Globals
 */

#ifdef RWDEBUG
static RwStream    *vrmlLogFile = NULL;
static RwInt32      indent = 0;
static RwInt32      lineLen = 0;

#endif /* RWDEBUG */

/****************************************************************************
 Functions
 */

#ifdef RWDEBUG

RwStream           *
vrmlLogOpen(const RwChar * name)
{
    RWFUNCTION(RWSTRING("vrmlLogOpen"));

    vrmlLogFile = RwStreamOpen(rwSTREAMFILENAME, rwSTREAMWRITE, name);
    RWRETURN(vrmlLogFile);
}

void
vrmlLogMsg(const RwChar * format, ...)
{
    RwChar              msg[512];
    RwInt32             strLen;
    va_list             ap;

    RWFUNCTION(RWSTRING("vrmlLogMsg"));

    va_start(ap, format);

    vsprintf(msg, format, ap);
    va_end(ap);

    if (!vrmlLogFile)
    {
        vrmlLogFile = vrmlLogOpen(LOGFILE);
        if (!vrmlLogFile)
        {
            RWRETURNVOID();
        }
    }

    strLen = rwstrlen(msg);

    if (lineLen == 0)
    {
        RwChar              tmp[512];

        rwsprintf(tmp, "%*s", indent + strLen, msg);
        rwstrcpy(msg, tmp);
    }

    lineLen += strLen;

    if (lineLen > MAXLINELEN)
    {
        rwstrcat(msg, "\n");
    }

    if (rwstrchr(msg, '\n'))
    {
        lineLen = 0;
    }

    RwStreamWrite(vrmlLogFile, msg, lineLen);

    RWRETURNVOID();
}

void
vrmlLogClose(void)
{
    RWFUNCTION(RWSTRING("vrmlLogClose"));

    if (vrmlLogFile)
    {
        RwStreamClose(vrmlLogFile, NULL);
        vrmlLogFile = NULL;
    }
    RWRETURNVOID();
}

void
vrmlLogIncIndent(void)
{
    RWFUNCTION(RWSTRING("vrmlLogIncIndent"));

    indent += INDENT;
    RWRETURNVOID();
}

void
vrmlLogDecIndent(void)
{
    RWFUNCTION(RWSTRING("vrmlLogDecIndent"));

    if (indent >= INDENT)
    {
        indent -= INDENT;
    }
    else
    {
        indent = 0;
    }
    RWRETURNVOID();
}

#endif /* RWDEBUG */
