#ifndef ANIMFUNCTTAB_H
#define ANIMFUNCTTAB_H

#include "rpvrmlanim.h"
#include "_rpvrml.h"

typedef    RwFrame *
  (*fpFrameAnimSetTranslationsFunc)
    (RwFrame * frame,
     RpVRMLAnimTranslate * translateAnim);

typedef    RwFrame *
  (*fpFrameAnimSetRotationsFunc)
    (RwFrame * frame,
     RpVRMLAnimRotate * rotateAnim);

typedef    RwFrame *
  (*fpFrameAnimSetScalesFunc)
    (RwFrame * frame,
     RpVRMLAnimScale * scaleAnim);

typedef    RwFrame *
  (*fpFrameAnimSetScaleOrientsFunc)
    (RwFrame * frame,
     RpVRMLAnimRotate *  scaleOrientAnim);

/* rotate */
typedef    RpVRMLAnimRotate *
  (*fpAnimRotateCreateFunc)
    (void);

typedef      RwBool
  (*fpAnimRotateDestroyFunc)
    (RpVRMLAnimRotate * rotateAnim);

typedef    RpVRMLAnimRotate *
  (*fpAnimRotateAddKeysFunc)
    (RpVRMLAnimRotate * rotateAnim,
     RwInt32 numKeys);

typedef    RpVRMLRotateKey *
  (*fpAnimRotateGetKeysFunc)
    (const RpVRMLAnimRotate * rotateAnim);

typedef    RpVRMLAnimRotate *
  (*fpAnimRotateSetControllerFunc)
    (RpVRMLAnimRotate * rotateAnim,
     RpVRMLAnimState * rotateCntrl);

/* translate */
typedef    RpVRMLAnimTranslate *
  (*fpAnimTranslateCreateFunc)
    (void);

typedef      RwBool
  (*fpAnimTranslateDestroyFunc)
    (RpVRMLAnimTranslate * translateAnim);

typedef    RpVRMLAnimTranslate *
  (*fpAnimTranslateAddKeysFunc)
    (RpVRMLAnimTranslate * translateAnim,
     RwInt32 numKeys);

typedef    RpVRMLTranslateKey *
  (*fpAnimTranslateGetKeysFunc)
    (const RpVRMLAnimTranslate * translateAnim);

typedef    RpVRMLAnimTranslate *
  (*fpAnimTranslateSetControllerFunc)
    (RpVRMLAnimTranslate * translateAnim,
     RpVRMLAnimState * translateCntrl);

/* scale */
typedef    RpVRMLAnimScale *
  (*fpAnimScaleCreateFunc)
    (void);

typedef      RwBool
  (*fpAnimScaleDestroyFunc)
    (RpVRMLAnimScale * scaleAnim);

typedef    RpVRMLAnimScale *
  (*fpAnimScaleAddKeysFunc)
    (RpVRMLAnimScale * scaleAnim,
     RwInt32 numKeys);

typedef    RpVRMLScaleKey *
  (*fpAnimScaleGetKeysFunc)
    (const RpVRMLAnimScale * scaleAnim);

typedef    RpVRMLAnimScale *
  (*fpAnimScaleSetControllerFunc)
    (RpVRMLAnimScale * scaleAnim,
     RpVRMLAnimState * scaleCntrl);

/* controller */
typedef    RpVRMLAnimState *
  (*fpAnimControllerCreateFunc)
    (RwInt32 numInterpolators);

typedef    RpVRMLAnimInterpolator *
  (*fpAnimControllerAddInterpolatorFunc)
    (RpVRMLAnimState *  animCntrl,
     RwInt32 interpNum, 
     RwInt16 startKey, 
     RwInt16 endKey, RwReal duration);

/* comp matrix */
typedef    RpVRMLAnimTransformState *
  (*fpFrameAnimGetMatrixCompFunc)
    (const RwFrame * frame);

/* name */
typedef    RwFrame *
  (*fpFrameAnimSetNameFunc)
    (RwFrame * frame, const char *name);

/* add time */
typedef    RwFrame *
  (*fpFrameAnimAddTimeFunc)
    (RwFrame * frame, RwReal time);

typedef struct RpVRMLAnimFunctions RpVRMLAnimFunctions;
struct RpVRMLAnimFunctions
{
    /* frame anim */
    fpFrameAnimSetTranslationsFunc fpFrameAnimSetTranslations;
    fpFrameAnimSetRotationsFunc fpFrameAnimSetRotations;
    fpFrameAnimSetScalesFunc fpFrameAnimSetScales;
    fpFrameAnimSetScaleOrientsFunc fpFrameAnimSetScaleOrients;

    /* rotate */
    fpAnimRotateCreateFunc fpAnimRotateCreate;
    fpAnimRotateDestroyFunc fpAnimRotateDestroy;
    fpAnimRotateAddKeysFunc fpAnimRotateAddKeys;
    fpAnimRotateGetKeysFunc fpAnimRotateGetKeys;
    fpAnimRotateSetControllerFunc fpAnimRotateSetController;

    /* translate */
    fpAnimTranslateCreateFunc fpAnimTranslateCreate;
    fpAnimTranslateDestroyFunc fpAnimTranslateDestroy;
    fpAnimTranslateAddKeysFunc fpAnimTranslateAddKeys;
    fpAnimTranslateGetKeysFunc fpAnimTranslateGetKeys;
    fpAnimTranslateSetControllerFunc fpAnimTranslateSetController;

    /* scale */
    fpAnimScaleCreateFunc fpAnimScaleCreate;
    fpAnimScaleDestroyFunc fpAnimScaleDestroy;
    fpAnimScaleAddKeysFunc fpAnimScaleAddKeys;
    fpAnimScaleGetKeysFunc fpAnimScaleGetKeys;
    fpAnimScaleSetControllerFunc fpAnimScaleSetController;

    /* controller */
    fpAnimControllerCreateFunc fpAnimControllerCreate;
    fpAnimControllerAddInterpolatorFunc fpAnimControllerAddInterpolator;

    /* comp matrix */
    fpFrameAnimGetMatrixCompFunc fpFrameAnimGetMatrixComp;

    /* name */
    fpFrameAnimSetNameFunc fpFrameAnimSetName;

    /* add time */
    fpFrameAnimAddTimeFunc fpFrameAnimAddTime;
};



#ifdef    __cplusplus
extern "C"
{
#endif         /* __cplusplus */

    void _rpVrmAnimFunctionsOpen(void);
    RpVRMLAnimFunctions *_rpVrmAnimFunctionsGet(void);

#ifdef    __cplusplus
}
#endif         /* __cplusplus */

#endif         /* ANIMFUNCTTAB_H */
