  /**********************************************************************
 *
 * File :     refinevars.c
 *
 * Abstract : Globals used within refinement (not exported to rwcore.h)
 *
 **********************************************************************
 *
 * This file is a product of Criterion Software Ltd.
 *
 * This file is provided as is with no warranties of any kind and is
 * provided without any obligation on Criterion Software Ltd. or
 * Canon Inc. to assist in its use or modification.
 *
 * Criterion Software Ltd. will not, under any
 * circumstances, be liable for any lost revenue or other damages arising
 * from the use of this file.
 *
 * Copyright (c) 1998 Criterion Software Ltd.
 * All Rights Reserved.
 *
 * RenderWare is a trademark of Canon Inc.
 *
 ************************************************************************/

#ifndef REFINEVARS_H
#define REFINEVARS_H

#include <rwcore.h>
#include <rpworld.h>

#if (defined(__ICL))
#if (400 <= __ICL)

#include <rtintel.h>

#if (450 <= __ICL)

/* Willamette New Instructions */
#define RW_WNI    1

#endif /* (450 <= __ICL) */

#endif /* (400 <= __ICL) */
#endif /* (defined(__ICL)) */

#include "rprefine.h"

#define    RPREFINE_SSE     0x01
#define    RPREFINE_WNI     0x02

/****************************************************************************
 Types
 */

typedef struct rpRefineGlobalVars RpRefineGlobalVars;
struct rpRefineGlobalVars
{
    RwInt32   engineOffset;  /* Offset into global data */
    RwInt32   atmExtOffset;  /* Offset into global data */

    RwInt32    *vertIndexArray;
    RwInt32   **vertIndexStarts;

    RwFreeList *atmExtFreeList;

    RwUInt32    sseFlag, enabledFlag;
};

typedef struct RpRefineAtomicExtension RpRefineAtomicExtension;
struct RpRefineAtomicExtension
{
    RpRefineAtomicDepthCallBack selectDepth;

    RwReal         farRange, invFarRange;
    RwInt32        curDepth;
};

typedef struct refineRefineData refineRefineData;
struct refineRefineData
{
    RwInt32    oldNumVerts, newNumVerts, oldNumTris, newNumTris, depth,
               numPresentUVs, numPresentRGBAs;

#ifdef RXPIPELINE

    RxCluster *idxs, *tris, *objVerts, *camVerts, *camNorms, *devVerts,
              **extraUVs, **extraRGBAs;

#endif /* RXPIPELINE */
};


#if (defined(__ICL))
#if (400 <= __ICL)

typedef struct refineSSERefineData refineSSERefineData;
struct refineSSERefineData
{
    refineRefineData    refineData;

    RwChar    *tri0, *tri1, *tri2, *tri3;
    RwChar    *camVert0, *camVert1, *camVert2, *camVert3;
    RwChar    *camNorm0, *camNorm1, *camNorm2, *camNorm3;
    RwChar    *devVert0, *devVert1, *devVert2, *devVert3;

    RwInt32    idxsStride;
    RwInt32    camVertsStride, camNormsStride, devVertsStride;
    RwInt32    triCamVertsStride, triCamNormsStride, triDevVertsStride;
    RwInt32    extraUVStride, extraRGBAStride;

    RpSSEOverlayM128      camWidth, camHeight, camOffsetX, camOffsetY;
    RpSSEOverlayM128      zScale, zShift, clipNear, clipFar;

    struct
    {
        RpSSEOverlayM128       xLoClip, xHiClip, yLoClip, yHiClip, zLoClip, zHiClip;
        RpSSEOverlayM128       xClip, yClip, zClip;
    } sse;

#ifdef RW_WNI

    struct
    {
        RpWNIOverlayM128i      xLoClip, xHiClip, yLoClip, yHiClip, zLoClip, zHiClip;
        RpWNIOverlayM128i      xClip, yClip, zClip;
    } wni;

#endif /* RW_WNI */

};

#endif /* (400 <= __ICL) */
#endif /* (defined(__ICL)) */


typedef struct refineCameraData refineCameraData;
struct refineCameraData
{
    RwReal              zScale;
    RwReal              zShift;
    RwReal              camWidth;
    RwReal              camHeight;
    RwReal              camOffsetX;
    RwReal              camOffsetY;
    RwReal              nearClip;
    RwReal              farClip;
};



#define RPREFINEOFFSET(_ptr, _offset) \
    (*(RpRefineAtomicExtension **)(((char *)(_ptr)) + (_offset)))


/****************************************************************************
 Defines
 */

#define REFINENUMCLUSTERSOFINTEREST 6
#define REFINENUMOUTPUTS            1

#ifdef    __cplusplus
extern              "C"
{
#endif                          /* __cplusplus */

/****************************************************************************
 * APIs
 */
extern RwBool _rtrefineSetupCamera( refineCameraData * cameraData );
extern RwBool _rtrefineGenerateNewVertIndex( refineRefineData * refineData );

extern RpRefineGlobalVars rpRefineGlobals;

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

#endif /* REFINEVARS_H */
